/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.graph.model;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import eu.dnetlib.data.graph.model.DNGFEntityDecoder;
import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import java.util.List;
import java.util.Map;

public class DNGFDecoder {
    private DNGFProtos.DNGF dngf;
    private DNGFEntityDecoder entityDecoder = null;
    private DNGFRelDecoder relDecoder = null;

    protected DNGFDecoder(byte[] value) {
        this(value, null);
    }

    protected DNGFDecoder(byte[] value, GeneratedMessage.GeneratedExtension ... ge) {
        try {
            ExtensionRegistry registry = ExtensionRegistry.newInstance();
            if (ge != null) {
                for (GeneratedMessage.GeneratedExtension e : ge) {
                    registry.add(e);
                }
            }
            this.dngf = DNGFProtos.DNGF.parseFrom(value, (ExtensionRegistryLite)registry);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("unable to deserialize proto: " + new String(value));
        }
    }

    private DNGFDecoder(DNGFProtos.DNGF dngf) {
        this.dngf = dngf;
    }

    public static DNGFDecoder decode(DNGFProtos.DNGF dngf) {
        return new DNGFDecoder(dngf);
    }

    public static DNGFDecoder decode(byte[] b) {
        return new DNGFDecoder(b);
    }

    public static DNGFDecoder decode(byte[] b, GeneratedMessage.GeneratedExtension ... ge) {
        return new DNGFDecoder(b, ge);
    }

    private static String escapeXml(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public KindProtos.Kind getKind() {
        return this.dngf.getKind();
    }

    public DNGFProtos.DNGF getDNGF() {
        return this.dngf;
    }

    public GeneratedMessage getMetadata() {
        return this.decodeEntity().getMetadata();
    }

    public GeneratedMessage getDNGFEntity() {
        return this.decodeEntity().getEntity();
    }

    public String getEntityId() {
        return this.decodeEntity().getId();
    }

    public DNGFProtos.DNGFEntity getEntity() {
        return this.dngf.getEntity();
    }

    public DNGFEntityDecoder decodeEntity() {
        if (this.entityDecoder == null) {
            this.entityDecoder = DNGFEntityDecoder.decode(this.getEntity());
        }
        return this.entityDecoder;
    }

    public DNGFProtos.DNGFRel getDNGFRel() {
        return this.dngf.getRel();
    }

    public FieldTypeProtos.Qualifier relType() {
        return this.decodeRel().getRelType();
    }

    public String relTypeName() {
        return this.relType().toString();
    }

    public String relSourceId() {
        return this.decodeRel().getRelSourceId();
    }

    public String relTargetId() {
        return this.decodeRel().getRelTargetId();
    }

    private DNGFRelDecoder decodeRel() {
        if (this.relDecoder == null) {
            this.relDecoder = DNGFRelDecoder.decode(this.getDNGFRel());
        }
        return this.relDecoder;
    }

    public byte[] toByteArray() {
        return this.dngf.toByteArray();
    }

    public String getColumnFamily() {
        switch (this.getKind()) {
            case entity: {
                return "metadata";
            }
            case relation: {
                return "rels";
            }
        }
        throw new IllegalArgumentException("invalid kind");
    }

    public String getRowkey() {
        switch (this.getKind()) {
            case entity: {
                return this.getEntityId();
            }
            case relation: {
                return this.getDNGFRel().getSource();
            }
        }
        throw new IllegalArgumentException("invalid kind");
    }

    public String getQualifier() {
        switch (this.getKind()) {
            case entity: {
                return this.getEntity().getType().toString();
            }
            case relation: {
                return this.getRelDescriptor().qualifier();
            }
        }
        throw new IllegalArgumentException("invalid kind");
    }

    public String asXml() {
        StringBuilder sb = new StringBuilder("<oaf>");
        for (Map.Entry e : this.dngf.getAllFields().entrySet()) {
            this.asXml(sb, (Descriptors.FieldDescriptor)e.getKey(), e.getValue());
        }
        sb.append("</oaf>");
        return sb.toString();
    }

    private void asXml(StringBuilder sb, Descriptors.FieldDescriptor fd, Object value) {
        if (fd.isRepeated() && value instanceof List) {
            for (Object o : (List)value) {
                this.asXml(sb, fd, o);
            }
        } else if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            sb.append("<" + fd.getName() + ">");
            for (Map.Entry e : ((Message)value).getAllFields().entrySet()) {
                this.asXml(sb, (Descriptors.FieldDescriptor)e.getKey(), e.getValue());
            }
            sb.append("</" + fd.getName() + ">");
        } else if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            sb.append("<" + fd.getName() + ">");
            sb.append(((Descriptors.EnumValueDescriptor)value).getName());
            sb.append("</" + fd.getName() + ">");
        } else {
            sb.append("<" + fd.getName() + ">");
            sb.append(DNGFDecoder.escapeXml(value.toString()));
            sb.append("</" + fd.getName() + ">");
        }
    }

    public RelDescriptor getRelDescriptor() {
        return this.decodeRel().getRelDescriptor();
    }
}

