package eu.dnetlib.data.graph.model;

import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.proto.DNGFProtos.DNGFEntity;
import eu.dnetlib.data.proto.DNGFProtos.DNGFRel;
import eu.dnetlib.data.proto.FieldTypeProtos.Qualifier;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class DNGFRelDecoder {

    private final DNGFRel dngfRel;

    private DNGFRelDecoder(final DNGFRel dngfRel) {
        this.dngfRel = dngfRel;
    }

	public static DNGFRelDecoder decode(final DNGFRel DNGFRel) {
		return new DNGFRelDecoder(DNGFRel);
	}

	public Qualifier getRelType() {
        return dngfRel.getRelType();
    }


    public RelDescriptor getRelDescriptor() {
        return new RelDescriptor(getDngfRel().getRelType().getSchemeid(), getDngfRel().getRelType().getClassid(), getRelTargetId());
    }

	public String getRelClass() {
        return dngfRel.getRelType().getClassid();
    }

	public String getRelScheme() {
        return dngfRel.getRelType().getSchemeid();
    }

	public DNGFRel.Builder setClassId(final String classId) {
        final DNGFRel.Builder relBuilder = DNGFRel.newBuilder(dngfRel);
        relBuilder.getRelTypeBuilder().setClassid(classId);
		return relBuilder;
	}

	public Type getTargetType() {
        return dngfRel.getTargetType();
    }

	public Type getSourceType() {
        return dngfRel.getSourceType();
    }


    public DNGFRel getDngfRel() {
        return dngfRel;
    }

	public String getCachedTargedId() {

        if (!dngfRel.hasCachedTarget()) return null;

        final DNGFEntity entity = dngfRel.getCachedTarget();
        return DNGFEntityDecoder.decode(entity).getId();
	}

	public String getRelSourceId() {
        return dngfRel.getSource();
    }

	public String getRelTargetId() {
        return dngfRel.getTarget();
    }

}
