package eu.dnetlib.data.transform;

import java.util.Map;

import com.google.gson.Gson;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by claudio on 12/12/2016.
 */
public class Ontology {

	private static final Log log = LogFactory.getLog(Ontology.class);

	private String code;
	private String description;

	private Map<String, OntologyTerm> terms;

	public String getCode() {
		return code;
	}

	public Ontology setCode(final String code) {
		this.code = code;
		return this;
	}

    public String getDescription() {
        return description;
    }

	public Ontology setDescription(final String description) {
		this.description = description;
		return this;
	}

    public Map<String, OntologyTerm> getTerms() {
        return terms;
    }

	public Ontology setTerms(final Map<String, OntologyTerm> terms) {
		this.terms = terms;
		return this;
	}

    public String inverseOf(final String termCode) {
        if (getTerms() == null || !getTerms().containsKey(termCode)) {
	        log.warn(String.format("unable to find inverse for term %s, terms: %s", termCode, getTerms()));
            return null;
        }
        return getTerms().get(termCode).getInverseCode();
    }

    public String inverseOf(final RelDescriptor rd) {
        if (getTerms() == null || !getTerms().containsKey(rd.getTermCode())) {
            return null;
        }
        return getTerms().get(rd.getTermCode()).getInverseCode();
    }

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

}
