package eu.dnetlib.data.transform.xml;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.proto.DNGFProtos.DNGF;
import eu.dnetlib.data.proto.DNGFProtos.DNGFEntity;
import eu.dnetlib.data.proto.DNGFProtos.DNGFRel;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.FieldTypeProtos.Qualifier;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.PersonProtos.Person;
import eu.dnetlib.data.proto.PersonProtos.Person.CoAuthor;
import eu.dnetlib.data.proto.TypeProtos.Type;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Created by claudio on 01/12/15.
 */
public class CommonDNetXsltFunctions extends AbstractDNetXsltFunctions {

	private static final int MAX_COAUTHORS = 50;

	public static String authorship(
			final String source,
			final String target,
			final int rank,
			final String relTypeId,
			final String relTypeScheme,
			final String provenanceAction,
			final String trust,
			final NodeList about) {

		final Map<String, String> params = Maps.newHashMap();
		params.put("rank", "" + rank);
        return rel(source, target, relTypeId, relTypeScheme, provenanceAction, trust, about, params);
    }

	public static String rel(
            final String source,
            final String target,
            final String relTypeId,
            final String relTypeScheme,
            final String provenanceAction,
            final String trust) {
		return rel(source, target, relTypeId, relTypeScheme, provenanceAction, trust, null, null);
	}

	public static String rel(
			final String source,
			final String target,
			final String relTypeId,
			final String relTypeScheme,
			final String provenanceAction,
			final String trust,
			final NodeList about) {
		return rel(source, target, relTypeId, relTypeScheme, provenanceAction, trust, about, null);
	}

	// dnet:oafRel($resultId, $datasetId, 'resultResult', 'part' 'isPartOf', $about)
	public static String rel(
            final String source,
            final String target,
            final String relTypeId,
            final String relTypeScheme,
            final String provenanceAction,
            final String trust,
            final NodeList about,
            final Map<String, String> params) {
        try {

            final DNGFRel.Builder rel = relProto(source, target, relTypeId, relTypeScheme);
            final DNGF oaf = getOaf(rel, getDataInfo(about, provenanceAction, trust, false, false));

            //TODO DO SOMEtHING WITH PARAM

            return base64(oaf.toByteArray());
        } catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }


    protected static DNGFRel.Builder relProto(
            final String source,
            final String target,
            final String relTypeId,
            final String relTypeScheme
    ) {
        try {
            final DNGFRowKeyDecoder sd = DNGFRowKeyDecoder.decode(source);
            final DNGFRowKeyDecoder td = DNGFRowKeyDecoder.decode(target);

            final Qualifier.Builder relType = getSimpleQualifier(relTypeId, relTypeScheme);
            final DNGFRel.Builder rel = getRel(sd.getKey(), sd.getType(), td.getKey(), td.getType(), relType.build(), false);

            return rel;

        } catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

	public static String person(
			final String personId,
			final NodeList about,
			final String provenanceAction,
			final String trust,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final String dateOfTransformation,
			final String fullname,
			final String nameIdentifier,
			final String nameIdentifierScheme) {
		return person(personId, fullname, nameIdentifier, nameIdentifierScheme, null, null, null, provenanceAction, trust, about, collectedFromId,
				collectedFromName, originalId, dateOfCollection, dateOfTransformation);
	}

	// $personId, $about, $provenance, $trust, $collectedfromid, $collectedfromname, $originalPersonId, $dateofcollection, normalize-space(.))
	public static String person(
			final String personId,
			final String fullname,
			final String nameIdentifier,
			final String nameIdentifierScheme,
			final NodeList authors,
			final String namespaceprefix,
			final String objIdentifier,
			final String provenanceAction,
			final String trust,
			final NodeList about,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final String dateOfTransformation) {
		try {
			final String entityId = DNGFRowKeyDecoder.decode(personId).getKey();

			final Person.Builder person = Person.newBuilder();
			final Person.Metadata.Builder metadata = getMetadata(fullname);

			if (authors != null) {
				for (int i = 0; (i < authors.getLength()) && (i < MAX_COAUTHORS); i++) {
					final Node node = authors.item(i);

					final String name = StringUtils.trim(node.getTextContent());
					if (!name.equals(fullname)) {

						final CoAuthor.Builder coAuthor = CoAuthor.newBuilder();

						coAuthor.setId(oafId("person", namespaceprefix, objIdentifier + "::" + name));
						coAuthor.setMetadata(getMetadata(name));

						person.addCoauthor(coAuthor);
					}
				}
			}

			final List<StructuredProperty> pids = Lists.newArrayList();
			if (StringUtils.isNotBlank(nameIdentifier) && StringUtils.isNotBlank(nameIdentifierScheme)) {
				pids.add(getStructuredProperty(nameIdentifier, nameIdentifierScheme, nameIdentifierScheme, "dnet:pid_types", "dnet:pid_types"));
			}

			final DNGFEntity.Builder entity =
					getEntity(Type.person, entityId, getKV(collectedFromId, collectedFromName), Lists.newArrayList(originalId), dateOfCollection,
							dateOfTransformation, pids)
							.setPerson(person.setMetadata(metadata));

			final DNGF oaf = getOaf(entity, getDataInfo(about, provenanceAction, trust, false, false));
			return base64(oaf.toByteArray());
		} catch (final Throwable e) {
			System.err.println("personId: " + personId);
			System.err.println("fullname: " + fullname);
			System.err.println("provenanceAction: " + provenanceAction);
			System.err.println("trust: " + trust);
			System.err.println("collectedFromId: " + collectedFromId);
			System.err.println("collectedFromName: " + collectedFromName);
			System.err.println("originalId: " + originalId);
			System.err.println("dateOfCollection: " + dateOfCollection);
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	private static Person.Metadata.Builder getMetadata(final String fullname) {
		final Person.Metadata.Builder metadata = Person.Metadata.newBuilder();

		metadata.setFullname(sf(fullname));

		final eu.dnetlib.pace.model.Person p = new eu.dnetlib.pace.model.Person(fullname, false);
		if (p.isAccurate()) {
			metadata.setFirstname(sf(p.getNormalisedFirstName()));
			metadata.clearSecondnames().addSecondnames(sf(p.getNormalisedSurname()));
			// metadata.setFullname(sf(p.getNormalisedFullname()));
		}
		return metadata;
	}

    protected static void manageTitle(NodeList titles, DatasetProtos.Dataset.Metadata.Builder metadataProto) {
        for (int i = 0; i < titles.getLength(); i++) {
            Node currentNode = titles.item(i);
            NodeList childNodes = currentNode.getChildNodes();
            if (childNodes.getLength() > 0) {
                String titleValue = childNodes.item(0).getNodeValue();
                String classname = "main title";
                String classid = "main title";
                if (currentNode.hasAttributes()) {
                    NamedNodeMap attributes = currentNode.getAttributes();
                    Node titleType = attributes.getNamedItem("titleType");

                    if (titleType != null && titleType.getNodeValue().equals("AlternativeTitle")) {
                        classname = "alternative title";
                        classid = "alternative title";
                    }
                    if (titleType != null && titleType.getNodeValue().equals("Subtitle")) {
                        classname = "subtitle";
                        classid = "subtitle";
                    }
                    if (titleType != null && titleType.getNodeValue().equals("TranslatedTitle")) {
                        classname = "translated title";
                        classid = "translated title";
                    }
                }
                addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("title"),
                        getStructuredProperty(titleValue, classname, classid, "dnet:dataCite_title", "dnet:dataCite_title"));
            }
        }
    }


    public static String relQualifier(final String ontology, final String termCode, final String targetId) {
        return new RelDescriptor(ontology, termCode, targetId).qualifier();
    }

    protected static void manageDate(NodeList dates, DatasetProtos.Dataset.Metadata.Builder metadataProto) {
        for (int i = 0; i < dates.getLength(); i++) {
            Node currentNode = dates.item(i);
            if (currentNode != null && currentNode.hasAttributes() && currentNode.hasChildNodes()) {
                String dateAttribute = currentNode.getAttributes().getNamedItem("dateType").getNodeValue();
                String dateValue = currentNode.getChildNodes().item(0).getNodeValue();
                String protoAttribute = "relevantdate";
                if ("Accepted".equals(dateAttribute)) {
                    protoAttribute = "dateofacceptance";
                } else if ("Issued".equals(dateAttribute)) {
                    protoAttribute = "storagedate";
                } else if ("Updated".equals(dateAttribute)) {
                    protoAttribute = "lastmetadataupdate";
                } else if ("Available".equals(dateAttribute)) {
                    protoAttribute = "embargoenddate";
                }
                if (protoAttribute.equals("relevantdate") == false) {
                    addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName(protoAttribute), dateValue);
                } else {
                    addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName(protoAttribute),
                            getStructuredProperty(dateValue, "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date"));
                }
            }
        }
    }

    public static String getFirstItem(final NodeList list) {
        String out = "";
        if (list != null) {

            if (list.getLength() > 0 && list.item(0).getChildNodes() != null && list.item(0).getChildNodes().getLength() > 0) {
                out = list.item(0).getChildNodes().item(0).getNodeValue();
            }
        }
        return out;
    }

}
