package eu.dnetlib.data.transform.xml;

import java.lang.reflect.Type;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;

/**
 * * <xsl:stylesheet ... xmlns:openTrials="eu.dnetlib.miscutils.functional.xml.OpenTrialsFunctions"> ... </xsl:stylesheet>
 * Created by alessia on 13/05/16.
 */
public class OpenTrialsXsltFunctions {

	/**
	 * Parses a json to get the first url item.
	 *
	 * @param jsonProvList A json string in the following format: [{"url" : "theUrl", "sourceID" : "theSourceId", "sourceName" : "theSourceName"}]
	 * @return the url value in the first object in the list
	 */
	public static String getMainIdentifierURL(String jsonProvList) {
		List<JsonProv> provs = getProvs(jsonProvList);
		for (JsonProv prov : provs) {
			if (StringUtils.isNotBlank(prov.getUrl())) return prov.getUrl();
		}
		return "";
	}


	public static List<JsonProv> getProvs(String jsonProvList) {
		Gson gson = new Gson();
		Type type = new TypeToken<List<JsonProv>>() {
		}.getType();
		return gson.fromJson(jsonProvList, type);
	}

	static class JsonProv {

		String url, sourceId, sourceName;

		public String getUrl() {
			return url;
		}

		public void setUrl(final String url) {
			this.url = url;
		}

		public String getSourceId() {
			return sourceId;
		}

		public void setSourceId(final String sourceId) {
			this.sourceId = sourceId;
		}

		public String getSourceName() {
			return sourceName;
		}

		public void setSourceName(final String sourceName) {
			this.sourceName = sourceName;
		}
	}
}
