package eu.dnetlib.data.transform;

import com.google.gson.Gson;

/**
 * Created by claudio on 12/12/2016.
 */
public class OntologyTerm {

	private String code;
	private String encoding;
	private String englishName;
	private String nativeName;

	private String inverseCode;

	public static OntologyTerm newInstance() {
		return new OntologyTerm();
	}

	public String getCode() {
		return code;
	}

	public String getEncoding() {
		return encoding;
	}

	public String getEnglishName() {
		return englishName;
	}

	public String getNativeName() {
		return nativeName;
	}

	public String getInverseCode() {
		return inverseCode;
	}

	public OntologyTerm setCode(final String code) {
		this.code = code;
		return this;
	}

	public OntologyTerm setEncoding(final String encoding) {
		this.encoding = encoding;
		return this;
	}

	public OntologyTerm setEnglishName(final String englishName) {
		this.englishName = englishName;
		return this;
	}

	public OntologyTerm setNativeName(final String nativeName) {
		this.nativeName = nativeName;
		return this;
	}

	public OntologyTerm setInverseCode(final String inverseCode) {
		this.inverseCode = inverseCode;
		return this;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

}
