/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Function;
import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import eu.dnetlib.data.transform.VtdUtilityParser;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.DocumentResult;

public class XsltRowTransformer
implements Function<String, List<Row>> {
    private static final Log log = LogFactory.getLog(XsltRowTransformer.class);
    public static final String DATA_XPATH = "/ROWS/ROW";
    public static final List<String> ATTRS = Arrays.asList("value", "mode");
    private Transformer transformer;

    public XsltRowTransformer(Transformer transformer) {
        this.transformer = transformer;
        log.info((Object)String.format("using trasformer: '%s'", this.getTransformerClassName()));
    }

    private List<Row> transform(String xml) {
        DocumentResult result = new DocumentResult();
        try {
            this.transformer.transform(new StreamSource(new StringReader(xml)), (Result)result);
            VTDGen parser = new VTDGen();
            parser.setDoc(result.getDocument().asXML().getBytes());
            parser.parse(true);
            VTDNav nav = parser.getNav();
            AutoPilot autoPilot = new AutoPilot(nav);
            return VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)autoPilot, (VTDNav)nav, (String)DATA_XPATH, ATTRS).stream().map(this::asRow).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error((Object)("Error parsing xml:\n" + xml), (Throwable)e);
            throw new RuntimeException("Unable to parse document:\n" + xml, e);
        }
    }

    private Row asRow(VtdUtilityParser.Node base64Node) {
        String base64 = (String)base64Node.getAttributes().get("value");
        if (StringUtils.isBlank((CharSequence)base64)) {
            throw new IllegalArgumentException("empty protocolbuffer value, check xslt");
        }
        DNGFDecoder d = DNGFDecoder.decode(Base64.decodeBase64((String)base64));
        String qualifier = this.getQualifier(base64Node, d);
        return new Row(d.getColumnFamily(), d.getRowkey(), Arrays.asList(new Column<String, byte[]>(qualifier, d.getDNGF().toByteArray())));
    }

    private String getQualifier(VtdUtilityParser.Node base64Node, DNGFDecoder d) {
        if ("update".equals(base64Node.getAttributes().get("mode"))) {
            return "update_" + System.nanoTime();
        }
        return d.getQualifier();
    }

    public String getTransformerClassName() {
        return this.transformer != null ? this.transformer.getClass().getName() : "unknown";
    }

    public List<Row> apply(String xml) {
        return this.transform(xml);
    }
}

