package eu.dnetlib.data.transform;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import com.google.common.base.Function;
import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.transform.VtdUtilityParser.Node;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.dom4j.io.DocumentResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XsltRowTransformer implements Function<String, List<Row>> {

	private static final Log log = LogFactory.getLog(XsltRowTransformer.class); // NOPMD by marko on 11/24/08 5:02 PM

	public static final String DATA_XPATH = "/ROWS/ROW";

	public static final List<String> ATTRS = Arrays.asList("value", "mode");

	private Transformer transformer;

	public XsltRowTransformer(final Transformer transformer) {
		this.transformer = transformer;
		log.info(String.format("using trasformer: '%s'", getTransformerClassName()));
	}

	private List<Row> transform(final String xml) {
		final DocumentResult result = new DocumentResult();
		try {
			transformer.transform(new StreamSource(new StringReader(xml)), result);

			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(new ByteArrayInputStream(result.getDocument().asXML().getBytes()));
			XPathFactory xPathfactory = XPathFactory.newInstance();
			XPath xpath = xPathfactory.newXPath();
			XPathExpression expr = xpath.compile("//ROW");

			NodeList evaluate = (NodeList) expr.evaluate(doc, XPathConstants.NODESET);
			final List<Row> resultRows = new ArrayList<>();
			for(int i = 0; i<evaluate.getLength(); i++){
				NamedNodeMap attributes = evaluate.item(i).getAttributes();


				if (attributes!= null && attributes.getNamedItem("value")!= null ) {
					final String value = attributes.getNamedItem("value").getTextContent();
					final String mode = attributes.getNamedItem("mode")!= null ?attributes.getNamedItem("mode").getTextContent():null;
					resultRows.add(asRow(value,mode));
				}

			}

			return resultRows;

//			final VTDGen parser = new VTDGen();
//			parser.setDoc(result.getDocument().asXML().getBytes());
//			parser.parse(false);
//
//			final VTDNav nav = parser.getNav();
//			final AutoPilot autoPilot = new AutoPilot(nav);
//			return VtdUtilityParser.getTextValuesWithAttributes(autoPilot, nav, DATA_XPATH, ATTRS)
//					.stream()
//					.map(this::asRow)
//					.collect(Collectors.toList());
		} catch (Exception e) {
			log.error("Error parsing xml:\n" + xml, e);
			throw new RuntimeException("Unable to parse document:\n" + xml, e);
		}
	}

	private Row asRow(final String base64, final String mode) {
//		final String base64 = base64Node.getAttributes().get("value");
		if (StringUtils.isBlank(base64))
			throw new IllegalArgumentException("empty protocolbuffer value, check xslt");

		final DNGFDecoder d = DNGFDecoder.decode(Base64.decodeBase64(base64));
		final String qualifier = getQualifier(mode, d);
		return new Row(d.getColumnFamily(), d.getRowkey(), Collections.singletonList(new Column<>(qualifier, d.getDNGF().toByteArray())));
	}

	private String getQualifier(final String mode, final DNGFDecoder d) {
		if("update".equals(mode)) {
			return "update_" + System.nanoTime();
		}
		return d.getQualifier();
	}

	public String getTransformerClassName() {
		return transformer != null ? transformer.getClass().getName() : "unknown";
	}

	@Override
	public List<Row> apply(final String xml) {
		return transform(xml);
	}

}
