package eu.dnetlib.data.transform.xml;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.proto.DNGFProtos.DNGF;
import eu.dnetlib.data.proto.DNGFProtos.DNGFEntity;
import eu.dnetlib.data.proto.DatasetProtos.Dataset;
import eu.dnetlib.data.proto.FieldTypeProtos.Instance;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.TypeProtos.Type;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfToHbaseXsltFunctions extends CommonDNetXsltFunctions {

	private static Map<String, String> mappingAccess = Maps.newHashMap();

	static {

		mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
		mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
		mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
		mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");

		// Transformator now maps the access rights into proper values, not sure if it does for all datasets.
		mappingAccess.put("OPEN", "OPEN");
		mappingAccess.put("CLOSED", "CLOSED");
		mappingAccess.put("RESTRICTED", "RESTRICTED");
		mappingAccess.put("EMBARGO", "EMBARGO");

	}

	protected static DNGFEntity.Builder odfDatasetProto(
			final String resultId,
			final NodeList about,
			final NodeList titles,
			final NodeList subjects,
			final NodeList publisher,
			final NodeList descriptions,
			final NodeList dates,
			final NodeList dateaccepted,
			final NodeList resourceTypes,
			final NodeList formats,
			final NodeList sizes,
			final NodeList languages,
			final NodeList cobjcategory,
			final NodeList contributors,
			final NodeList rights,
			final NodeList version,
			final NodeList pidList,
			final String hostedbyId,
			final String hostedbyName,
			final String collectedfromId,
			final String collectedfromName,
			final NodeList originalIds,
			final String instanceUri,
			final String dateOfCollection,
			final String dateOfTransformation) {

		final String entityId = DNGFRowKeyDecoder.decode(resultId).getKey();

		final Dataset.Builder dataset = Dataset.newBuilder();
		Dataset.Metadata.Builder metadataProto = Dataset.Metadata.newBuilder();

		// subject
		for (int i = 0; i < subjects.getLength(); i++) {
			Node currentNode = subjects.item(i);
			NodeList childNodes = currentNode.getChildNodes();
			if (childNodes.getLength() > 0) {
				String subjectValue = childNodes.item(0).getNodeValue();
				addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("subject"),
						getStructuredProperty(subjectValue, "keyword", "keyword", "dnet:result_subject", "dnet:result_subject"));
			}
		}

		// title
        manageTitle(titles, metadataProto);

		// description
		for (int i = 0; i < descriptions.getLength(); i++) {
			Node currentNode = descriptions.item(i);
			if (currentNode != null && currentNode.hasChildNodes()) {
				String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
				addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
			}
		}

		// contributors
		for (int i = 0; i < contributors.getLength(); i++) {
			Node currentNode = contributors.item(i);
			if (currentNode != null && currentNode.hasChildNodes()) {
				String contributorValue = currentNode.getChildNodes().item(0).getNodeValue();
				addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("contributor"), contributorValue);
			}
		}

		// publisher
		addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("publisher"), getFirstItem(publisher));

		// dates
        manageDate(dates, metadataProto);


		// dateofacceptance
		addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("dateofacceptance"), getFirstItem(dateaccepted));

		// size
		addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("size"), getFirstItem(sizes));

		// format
		addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("format"), getFirstItem(formats));

		// version
		addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("version"), getFirstItem(version));

		// language
		addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("language"),
				setQualifier(getDefaultQualifier("dnet:languages"), Lists.newArrayList(getFirstItem(languages))));

		//resource type
		addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("resourcetype"),
				setQualifier(getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList(getFirstItem(resourceTypes))));

		// resultType
		addField(metadataProto, Dataset.Metadata.getDescriptor().findFieldByName("resulttype"), getSimpleQualifier("dataset", "dnet:result_typologies"));

		String tmpID;
		String TmpName;

		if (hostedbyId == null && hostedbyName == null) {
			tmpID = collectedfromId;
			TmpName = collectedfromName;
		} else {
			tmpID = hostedbyId;
			TmpName = hostedbyName;
		}

		final Instance.Builder instance = Instance.newBuilder().setHostedby(getKV(tmpID, TmpName));

		String tmpRigths = "UNKNOWN";
		final String firstRight = getFirstItem(rights);
		if (mappingAccess.containsKey(firstRight)) {
			tmpRigths = mappingAccess.get(firstRight);
		}

		addField(instance, Instance.getDescriptor().findFieldByName("licence"),
				setQualifier(getDefaultQualifier("dnet:access_modes"), Lists.newArrayList(tmpRigths)));

		addField(instance, Instance.getDescriptor().findFieldByName("instancetype"),
				setQualifier(getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList(getFirstItem(cobjcategory))));

		addField(instance, Instance.getDescriptor().findFieldByName("url"), instanceUri);

		dataset.addInstance(instance);

		List<StructuredProperty> pids = parsePids(pidList);

		// original ids
		final List<String> originalIdList = Lists.newArrayList();
		for (int i = 0; i < originalIds.getLength(); i++) {
			Node currentNode = originalIds.item(i);
			if (currentNode != null && currentNode.hasChildNodes()) {
				originalIdList.add(currentNode.getChildNodes().item(0).getNodeValue());
			}
		}

		DNGFEntity.Builder entity =
				getEntity(Type.dataset, entityId, getKV(collectedfromId, collectedfromName), originalIdList, dateOfCollection, dateOfTransformation, pids).setDataset(
						dataset.setMetadata(metadataProto));

		entity.setOaiprovenance(getOAIProvenance(about));

		return entity;
	}


    public static String odfDataset(
			final String resultId,
			final NodeList about,
			final NodeList metadata,
			final NodeList titles,
			final NodeList subjects,
			final NodeList publisher,
			final NodeList descriptions,
			final NodeList dates,
			final NodeList dateaccepted,
			final NodeList resourceTypes,
			final NodeList formats,
			final NodeList sizes,
			final NodeList languages,
			final NodeList cobjcategory,
			final NodeList contributors,
			final NodeList rights,
			final NodeList version,
			final NodeList pidList,
			final String provenance,
			final String trust,
			final String hostedbyId,
			final String hostedbyName,
			final String collectedfromId,
			final String collectedfromName,
			final NodeList originalIds,
			final String instanceUri,
			final String dateOfCollection,
			final String dateOfTransformation) {

		try {
			final DNGFEntity.Builder entity = odfDatasetProto(
					resultId, about, titles, subjects, publisher, descriptions, dates, dateaccepted,
					resourceTypes, formats, sizes, languages, cobjcategory, contributors, rights, version,
					pidList, hostedbyId, hostedbyName, collectedfromId, collectedfromName,
					originalIds, instanceUri, dateOfCollection, dateOfTransformation);

			final DNGF dngf = getOaf(entity, getDataInfo(about, provenance, trust, false, false));
			return base64(dngf.toByteArray());
		} catch (Throwable e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}

	}



}
