/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.graph.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.Arrays;
import java.util.Set;

public class DNGFUtils {
    public static Set<String> entities() {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])TypeProtos.Type.values()), t -> t.toString()));
    }

    public static Predicate<DNGFProtos.DNGF> relationFilter() {
        return dngf -> dngf.getKind().equals((Object)KindProtos.Kind.relation);
    }

    public static Predicate<DNGFProtos.DNGF> entityFilter() {
        return dngf -> dngf.getKind().equals((Object)KindProtos.Kind.entity);
    }

    public static Function<DNGFDecoder, String> idDecoder() {
        return input -> input.getEntityId();
    }

    public static Predicate<FieldTypeProtos.StructuredProperty> mainTitleFilter() {
        return sp -> sp.getQualifier() != null && sp.getQualifier().getClassname().equals("main title");
    }

    public static Set<String> getFieldNames(Descriptors.Descriptor d, Integer ... tag) {
        return Sets.newHashSet((Iterable)Iterables.transform(Arrays.asList(tag), i -> {
            Descriptors.FieldDescriptor fd = d.findFieldByNumber(i.intValue());
            if (fd == null) {
                throw new IllegalArgumentException("undefined tag: " + i + " for type: " + d.getFullName());
            }
            return fd.getName();
        }));
    }

    public static FieldTypeProtos.StringField sf(String value) {
        return FieldTypeProtos.StringField.newBuilder().setValue(value).build();
    }

    public static FieldTypeProtos.StructuredProperty sp(String value, String classid, String schemeid) {
        return DNGFUtils.sp(value, classid, schemeid, DNGFUtils.di());
    }

    public static FieldTypeProtos.StructuredProperty sp(String value, String classid, String schemeid, FieldTypeProtos.DataInfo di) {
        return FieldTypeProtos.StructuredProperty.newBuilder().setValue(value).setQualifier(DNGFUtils.simpleQualifier(classid, schemeid)).setDataInfo(di).build();
    }

    public static FieldTypeProtos.KeyValue kv(String k, String v) {
        return FieldTypeProtos.KeyValue.newBuilder().setKey(k).setValue(v).build();
    }

    public static FieldTypeProtos.Qualifier simpleQualifier(String classid, String schemeid) {
        return DNGFUtils.q(classid, classid, schemeid, schemeid);
    }

    public static FieldTypeProtos.Qualifier q(String classid, String classname, String schemeid, String schemename) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemename(schemeid).setSchemeid(schemename).build();
    }

    public static FieldTypeProtos.DataInfo di(String trust) {
        return DNGFUtils.di(false, "", false, DNGFUtils.simpleQualifier("", ""), trust);
    }

    public static FieldTypeProtos.DataInfo di() {
        return DNGFUtils.di("");
    }

    public static FieldTypeProtos.DataInfo di(Boolean deletedByInference, String inferenceProvenance, Boolean inferred, FieldTypeProtos.Qualifier provenanceAction, String trust) {
        return FieldTypeProtos.DataInfo.newBuilder().setDeletedbyinference(deletedByInference).setInferenceprovenance(inferenceProvenance).setInferred(inferred).setProvenanceaction(provenanceAction).setTrust(trust).build();
    }

    public static FieldTypeProtos.Context context(String id) {
        return FieldTypeProtos.Context.newBuilder().setId(id).build();
    }

    public static DNGFDecoder embed(GeneratedMessage msg, KindProtos.Kind kind, boolean deletedByInference, boolean inferred, String provenance, String action) {
        DNGFProtos.DNGF.Builder DNGF2 = DNGFProtos.DNGF.newBuilder().setKind(kind).setLastupdatetimestamp(System.currentTimeMillis()).setDataInfo(DNGFUtils.di(deletedByInference, provenance, inferred, DNGFUtils.simpleQualifier(action, action), "0.5"));
        switch (kind) {
            case entity: {
                DNGF2.setEntity((DNGFProtos.DNGFEntity)msg);
                break;
            }
            case relation: {
                DNGF2.setRel((DNGFProtos.DNGFRel)msg);
                break;
            }
        }
        return DNGFDecoder.decode(DNGF2.build());
    }

    public static DNGFDecoder embed(GeneratedMessage msg, KindProtos.Kind kind) {
        return DNGFUtils.embed(msg, kind, false, false, "inference_provenance", "provenance_action");
    }
}

