/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.graph.utils;

import eu.dnetlib.data.proto.FieldTypeProtos;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RelDescriptor {
    public static final String ONTOLOGY_SEPARATOR = "_";
    public static final String QUALIFIER_SEPARATOR = ":";
    public static final String RELTYPE_REGEX = "(\\w+_\\w+)_(\\w+)";
    public static final String ID_REGEX = "([0-9][0-9]\\|.{12}::[a-zA-Z0-9]{32})";
    public static final Pattern QUALIFIER_PATTERN = Pattern.compile("^(\\w+_\\w+)_(\\w+)$");
    public static final Pattern FULL_QUALIFIER_PATTERN = Pattern.compile("^(\\w+_\\w+)_(\\w+):([0-9][0-9]\\|.{12}::[a-zA-Z0-9]{32})$");
    private String code;
    private String ontologyCode;
    private String termCode;
    private String targetId = null;

    public RelDescriptor(String ontologyCode, String termCode) {
        this.ontologyCode = ontologyCode;
        this.termCode = termCode;
        this.code = ontologyCode + ONTOLOGY_SEPARATOR + termCode;
    }

    public RelDescriptor(String ontologyCode, String termCode, String targetId) {
        this(ontologyCode, termCode);
        this.targetId = targetId;
    }

    public RelDescriptor(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("empty value is not permitted");
        }
        Matcher matcher = QUALIFIER_PATTERN.matcher(value);
        if (matcher.matches()) {
            this.code = value;
            this.ontologyCode = matcher.group(1);
            this.termCode = matcher.group(2);
        } else {
            Matcher fullMatcher = FULL_QUALIFIER_PATTERN.matcher(value);
            if (fullMatcher.matches()) {
                this.code = fullMatcher.group(1) + ONTOLOGY_SEPARATOR + fullMatcher.group(2);
                this.ontologyCode = fullMatcher.group(1);
                this.termCode = fullMatcher.group(2);
                this.targetId = fullMatcher.group(3);
            } else {
                throw new IllegalArgumentException(String.format("invalid qualifier format: '%s'", value));
            }
        }
    }

    public String shortQualifier() {
        return this.getOntologyCode() + ONTOLOGY_SEPARATOR + this.getTermCode();
    }

    public String qualifier() {
        return this.qualifier(this.getTargetId());
    }

    public String qualifier(String targetId) {
        if (StringUtils.isBlank((CharSequence)targetId)) {
            throw new IllegalStateException("incomplete qualifier");
        }
        return this.shortQualifier() + QUALIFIER_SEPARATOR + targetId;
    }

    public static String asString(FieldTypeProtos.Qualifier qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException("invalid qualifier");
        }
        return qualifier.getSchemeid() + ONTOLOGY_SEPARATOR + qualifier.getClassid();
    }

    public FieldTypeProtos.Qualifier asQualifier() {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(this.getTermCode()).setClassname(this.getTermCode()).setSchemeid(this.getOntologyCode()).setSchemename(this.getOntologyCode()).build();
    }

    public String getCode() {
        return this.code;
    }

    public String getOntologyCode() {
        return this.ontologyCode;
    }

    public String getTermCode() {
        return this.termCode;
    }

    public String toString() {
        return this.getCode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelDescriptor other = (RelDescriptor)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }
}

