/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.transform.AbstractProtoMapper;
import eu.dnetlib.pace.config.Type;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SolrProtoMapper
extends AbstractProtoMapper {
    private static final String ID_SEPARATOR = "::";
    private Document fields;

    public SolrProtoMapper(String fields) throws DocumentException {
        this.fields = this.parse(fields);
        if (StringUtils.isBlank((CharSequence)this.fields.valueOf("//FIELD[@name = 'objIdentifier']/@name"))) {
            throw new IllegalArgumentException("field objIdentifier is mandatory");
        }
    }

    public SolrInputDocument map(GeneratedMessage proto, String version, String dsId, String actionSetId) throws DocumentException {
        SolrInputDocument doc = new SolrInputDocument();
        for (Object o : this.fields.selectNodes("//FIELD[string(@path)]")) {
            Element e = (Element)o;
            String name = e.attribute("name").getValue().toLowerCase().trim();
            String path = e.attribute("path").getValue();
            doc.setField(name, this.processMultiPath(proto, Lists.newLinkedList((Iterable)Splitter.on((String)"|").trimResults().split((CharSequence)path)), Type.String));
        }
        String objIdentifier = this.patchId((String)doc.getFieldValue("objidentifier"));
        doc.setField("objidentifier", (Object)objIdentifier);
        doc.setField("__indexrecordidentifier", (Object)this.getRecordId(objIdentifier, actionSetId));
        doc.setField("__dsid", (Object)dsId);
        doc.setField("__dsversion", (Object)version);
        doc.setField("__result", (Object)Base64.encodeBase64String((byte[])proto.toByteArray()));
        doc.setField("actionset", (Object)actionSetId);
        return doc;
    }

    public String getRecordId(String objIdentifier, String actionSetId) {
        return objIdentifier + ID_SEPARATOR + actionSetId;
    }

    private String patchId(String objidentifier) {
        return objidentifier.contains("|") ? StringUtils.substringAfter((String)objidentifier, (String)"|") : objidentifier;
    }

    private Document parse(String s) throws DocumentException {
        return new SAXReader().read((Reader)new StringReader(s));
    }
}

