/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.CommonDNetXsltFunctions;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbmfToHbaseXsltFunctions
extends CommonDNetXsltFunctions {
    public static String oafEntity(String id, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, String dateOfTransformation, NodeList nodeList) {
        DNGFRowKeyDecoder d = DNGFRowKeyDecoder.decode(id);
        String entityId = d.getKey();
        switch (d.getType()) {
            case datasource: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.datasource, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, dateOfTransformation, (Message.Builder)DatasourceProtos.Datasource.newBuilder());
            }
            case organization: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.organization, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, dateOfTransformation, (Message.Builder)OrganizationProtos.Organization.newBuilder());
            }
            case person: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.person, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, dateOfTransformation, (Message.Builder)PersonProtos.Person.newBuilder());
            }
            case project: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.project, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, dateOfTransformation, (Message.Builder)ProjectProtos.Project.newBuilder());
            }
            case publication: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.publication, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, dateOfTransformation, (Message.Builder)PublicationProtos.Publication.newBuilder());
            }
            case dataset: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.dataset, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, dateOfTransformation, (Message.Builder)DatasetProtos.Dataset.newBuilder());
            }
        }
        throw new IllegalArgumentException("Invalid entity type: " + (Object)((Object)d.getType()));
    }

    public static String rel(String source, String target, String relClass, String relScheme) {
        return DbmfToHbaseXsltFunctions.rel(source, target, null, relClass, relScheme);
    }

    public static String rel(String source, String target, NodeList nodeList, String relClass, String relScheme) {
        DNGFRowKeyDecoder sd = DNGFRowKeyDecoder.decode(source);
        DNGFRowKeyDecoder td = DNGFRowKeyDecoder.decode(target);
        FieldTypeProtos.Qualifier relType = DbmfToHbaseXsltFunctions.getSimpleQualifier(relClass, relScheme).build();
        return DbmfToHbaseXsltFunctions.serializeOafRel(nodeList, sd.getKey(), sd.getType(), td.getKey(), td.getType(), relType, false);
    }

    protected static String serializeOafEntity(NodeList nodelist, TypeProtos.Type type, String id, FieldTypeProtos.KeyValue collectedFrom, String originalId, String dateOfCollection, String dateOfTransformation, Message.Builder entity) {
        try {
            Descriptors.FieldDescriptor instanceDescriptor;
            FieldTypeProtos.Instance.Builder instance;
            Descriptors.FieldDescriptor md = entity.getDescriptorForType().findFieldByName("metadata");
            DNGFProtos.DNGFEntity.Builder parent = DbmfToHbaseXsltFunctions.getEntity(type, id, collectedFrom, Lists.newArrayList((Object[])new String[]{originalId}), dateOfCollection, dateOfTransformation, null);
            Message.Builder metadata = entity.newBuilderForField(md);
            FieldTypeProtos.DataInfo.Builder dataInfo = FieldTypeProtos.DataInfo.newBuilder();
            if (type.equals((Object)TypeProtos.Type.publication)) {
                instance = FieldTypeProtos.Instance.newBuilder();
                DbmfToHbaseXsltFunctions.parseNodelist(nodelist, new Message.Builder[]{instance});
                instanceDescriptor = PublicationProtos.Publication.getDescriptor().findFieldByName(FieldTypeProtos.Instance.getDescriptor().getName());
                if (instanceDescriptor != null) {
                    entity.setField(instanceDescriptor, (Object)instance);
                }
            }
            if (type.equals((Object)TypeProtos.Type.dataset)) {
                instance = FieldTypeProtos.Instance.newBuilder();
                DbmfToHbaseXsltFunctions.parseNodelist(nodelist, new Message.Builder[]{instance});
                instanceDescriptor = DatasetProtos.Dataset.getDescriptor().findFieldByName(FieldTypeProtos.Instance.getDescriptor().getName());
                if (instanceDescriptor != null) {
                    entity.setField(instanceDescriptor, (Object)instance);
                }
            }
            DbmfToHbaseXsltFunctions.parseNodelist(nodelist, new Message.Builder[]{parent, entity, metadata, dataInfo});
            Descriptors.FieldDescriptor entityDescriptor = DNGFProtos.DNGFEntity.getDescriptor().findFieldByName(type.toString());
            DNGFProtos.DNGF build = DbmfToHbaseXsltFunctions.getOaf((DNGFProtos.DNGFEntity.Builder)parent.setField(entityDescriptor, entity.setField(md, (Object)metadata.build()).build()), dataInfo);
            return DbmfToHbaseXsltFunctions.base64(build.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    protected static String serializeOafRel(NodeList nodeList, String sourceId, TypeProtos.Type sourceType, String targetId, TypeProtos.Type targetType, FieldTypeProtos.Qualifier relType, boolean isChild) {
        try {
            FieldTypeProtos.DataInfo.Builder dataInfo = FieldTypeProtos.DataInfo.newBuilder();
            DbmfToHbaseXsltFunctions.parseNodelist(nodeList, new Message.Builder[]{dataInfo});
            DNGFProtos.DNGFRel.Builder builder = DbmfToHbaseXsltFunctions.getRel(sourceId, sourceType, targetId, targetType, relType, isChild);
            DNGFProtos.DNGF build = DbmfToHbaseXsltFunctions.getOaf(builder, dataInfo);
            return DbmfToHbaseXsltFunctions.base64(build.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    private static void parseNodelist(NodeList nodeList, Message.Builder ... builders) {
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node fieldNode = nodeList.item(i);
            Node attr = fieldNode.getAttributes().getNamedItem("name");
            String fieldName = attr.getNodeValue();
            NodeList chilidren = fieldNode.getChildNodes();
            for (int j = 0; j < chilidren.getLength(); ++j) {
                Node child = chilidren.item(j);
                String childName = child.getLocalName();
                if (!"ITEM".equals(childName) && !StringUtils.isBlank((CharSequence)childName)) continue;
                for (Message.Builder builder : builders) {
                    String text;
                    Descriptors.FieldDescriptor desc = builder.getDescriptorForType().findFieldByName(fieldName);
                    if (desc == null || StringUtils.isBlank((CharSequence)(text = DbmfToHbaseXsltFunctions.getText(StringUtils.isBlank((CharSequence)childName) ? fieldNode : child)))) continue;
                    DbmfToHbaseXsltFunctions.addField(builder, desc, text);
                }
            }
        }
    }

    private static String getText(Node node) {
        StringBuffer result = new StringBuffer();
        if (!node.hasChildNodes()) {
            return "";
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() == 4) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() != 5) continue;
            result.append(DbmfToHbaseXsltFunctions.getText(subnode));
        }
        return result.toString().trim();
    }
}

