/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.CommonDNetXsltFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfToHbaseXsltFunctions
extends CommonDNetXsltFunctions {
    private static Map<String, String> mappingAccess = Maps.newHashMap();

    protected static DNGFProtos.DNGFEntity.Builder odfDatasetProto(String resultId, NodeList about, NodeList titles, NodeList subjects, NodeList publisher, NodeList descriptions, NodeList dates, NodeList dateaccepted, NodeList resourceTypes, NodeList formats, NodeList sizes, NodeList languages, NodeList cobjcategory, NodeList contributors, NodeList rights, NodeList version, NodeList pidList, String hostedbyId, String hostedbyName, String collectedfromId, String collectedfromName, NodeList originalIds, String instanceUri, String dateOfCollection, String dateOfTransformation) {
        String TmpName;
        String tmpID;
        Node currentNode;
        int i;
        String entityId = DNGFRowKeyDecoder.decode(resultId).getKey();
        DatasetProtos.Dataset.Builder dataset = DatasetProtos.Dataset.newBuilder();
        DatasetProtos.Dataset.Metadata.Builder metadataProto = DatasetProtos.Dataset.Metadata.newBuilder();
        for (i = 0; i < subjects.getLength(); ++i) {
            currentNode = subjects.item(i);
            NodeList childNodes = currentNode.getChildNodes();
            if (childNodes.getLength() <= 0) continue;
            String subjectValue = childNodes.item(0).getNodeValue();
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("subject"), OdfToHbaseXsltFunctions.getStructuredProperty(subjectValue, "keyword", "keyword", "dnet:result_subject", "dnet:result_subject"));
        }
        OdfToHbaseXsltFunctions.manageTitle(titles, metadataProto);
        for (i = 0; i < descriptions.getLength(); ++i) {
            currentNode = descriptions.item(i);
            if (currentNode == null || !currentNode.hasChildNodes()) continue;
            String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
        }
        for (i = 0; i < contributors.getLength(); ++i) {
            currentNode = contributors.item(i);
            if (currentNode == null || !currentNode.hasChildNodes()) continue;
            String contributorValue = currentNode.getChildNodes().item(0).getNodeValue();
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("contributor"), contributorValue);
        }
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("publisher"), OdfToHbaseXsltFunctions.getFirstItem(publisher));
        OdfToHbaseXsltFunctions.manageDate(dates, metadataProto);
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("dateofacceptance"), OdfToHbaseXsltFunctions.getFirstItem(dateaccepted));
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("size"), OdfToHbaseXsltFunctions.getFirstItem(sizes));
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("format"), OdfToHbaseXsltFunctions.getFirstItem(formats));
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("version"), OdfToHbaseXsltFunctions.getFirstItem(version));
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("language"), OdfToHbaseXsltFunctions.setQualifier(OdfToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), Lists.newArrayList((Object[])new String[]{OdfToHbaseXsltFunctions.getFirstItem(languages)})));
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("resourcetype"), OdfToHbaseXsltFunctions.setQualifier(OdfToHbaseXsltFunctions.getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList((Object[])new String[]{OdfToHbaseXsltFunctions.getFirstItem(resourceTypes)})));
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("resulttype"), OdfToHbaseXsltFunctions.getSimpleQualifier("dataset", "dnet:result_typologies"));
        if (hostedbyId == null && hostedbyName == null) {
            tmpID = collectedfromId;
            TmpName = collectedfromName;
        } else {
            tmpID = hostedbyId;
            TmpName = hostedbyName;
        }
        FieldTypeProtos.Instance.Builder instance = FieldTypeProtos.Instance.newBuilder().setHostedby(OdfToHbaseXsltFunctions.getKV(tmpID, TmpName));
        String tmpRigths = "UNKNOWN";
        String firstRight = OdfToHbaseXsltFunctions.getFirstItem(rights);
        if (mappingAccess.containsKey(firstRight)) {
            tmpRigths = mappingAccess.get(firstRight);
        }
        OdfToHbaseXsltFunctions.addField((Message.Builder)instance, FieldTypeProtos.Instance.getDescriptor().findFieldByName("licence"), OdfToHbaseXsltFunctions.setQualifier(OdfToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), Lists.newArrayList((Object[])new String[]{tmpRigths})));
        OdfToHbaseXsltFunctions.addField((Message.Builder)instance, FieldTypeProtos.Instance.getDescriptor().findFieldByName("instancetype"), OdfToHbaseXsltFunctions.setQualifier(OdfToHbaseXsltFunctions.getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList((Object[])new String[]{OdfToHbaseXsltFunctions.getFirstItem(cobjcategory)})));
        OdfToHbaseXsltFunctions.addField((Message.Builder)instance, FieldTypeProtos.Instance.getDescriptor().findFieldByName("url"), instanceUri);
        dataset.addInstance(instance);
        List<FieldTypeProtos.StructuredProperty> pids = OdfToHbaseXsltFunctions.parsePids(pidList);
        ArrayList originalIdList = Lists.newArrayList();
        for (int i2 = 0; i2 < originalIds.getLength(); ++i2) {
            Node currentNode2 = originalIds.item(i2);
            if (currentNode2 == null || !currentNode2.hasChildNodes()) continue;
            originalIdList.add(currentNode2.getChildNodes().item(0).getNodeValue());
        }
        DNGFProtos.DNGFEntity.Builder entity = OdfToHbaseXsltFunctions.getEntity(TypeProtos.Type.dataset, entityId, OdfToHbaseXsltFunctions.getKV(collectedfromId, collectedfromName), originalIdList, dateOfCollection, dateOfTransformation, pids).setDataset(dataset.setMetadata(metadataProto));
        entity.setOaiprovenance(OdfToHbaseXsltFunctions.getOAIProvenance(about));
        return entity;
    }

    public static String odfDataset(String resultId, NodeList about, NodeList metadata, NodeList titles, NodeList subjects, NodeList publisher, NodeList descriptions, NodeList dates, NodeList dateaccepted, NodeList resourceTypes, NodeList formats, NodeList sizes, NodeList languages, NodeList cobjcategory, NodeList contributors, NodeList rights, NodeList version, NodeList pidList, String provenance, String trust, String hostedbyId, String hostedbyName, String collectedfromId, String collectedfromName, NodeList originalIds, String instanceUri, String dateOfCollection, String dateOfTransformation) {
        try {
            DNGFProtos.DNGFEntity.Builder entity = OdfToHbaseXsltFunctions.odfDatasetProto(resultId, about, titles, subjects, publisher, descriptions, dates, dateaccepted, resourceTypes, formats, sizes, languages, cobjcategory, contributors, rights, version, pidList, hostedbyId, hostedbyName, collectedfromId, collectedfromName, originalIds, instanceUri, dateOfCollection, dateOfTransformation);
            DNGFProtos.DNGF dngf = OdfToHbaseXsltFunctions.getOaf(entity, OdfToHbaseXsltFunctions.getDataInfo(about, provenance, trust, false, false));
            return OdfToHbaseXsltFunctions.base64(dngf.toByteArray());
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    static {
        mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
        mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
        mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
        mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");
        mappingAccess.put("OPEN", "OPEN");
        mappingAccess.put("CLOSED", "CLOSED");
        mappingAccess.put("RESTRICTED", "RESTRICTED");
        mappingAccess.put("EMBARGO", "EMBARGO");
    }
}

