/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.msro.workflows.nodes.hadoop.AbstractHBaseAdminJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExistHBaseTableJobNode
extends AbstractHBaseAdminJobNode {
    private static final Log log = LogFactory.getLog(ExistHBaseTableJobNode.class);

    protected String execute(Env env) throws Exception {
        log.info((Object)("checking table existance: '" + this.getTableName() + "' on cluster: '" + this.getCluster() + "'"));
        HadoopService hadoopService = (HadoopService)this.getServiceLocator().getService(HadoopService.class);
        boolean exists = hadoopService.existHbaseTable(this.getCluster(), this.getTableName());
        log.info((Object)("table '" + this.getTableName() + "' exists: " + exists));
        if (exists) {
            String tableDesc = hadoopService.describeHBaseTableConfiguration(this.getCluster(), this.getTableName());
            env.setAttribute(this.getTableConfigurationParamName(), (Object)tableDesc);
        }
        return exists ? "drop" : "define";
    }
}

