package eu.dnetlib.msro.workflows.nodes.dedup;

import java.util.Queue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.pace.config.DedupConfig;

/**
 * The Class DedupConfigurationOrchestration.
 */
public class DedupConfigurationOrchestration {

	/**
	 * The entity.
	 */
	private Entity entity;

	/**
	 * The action set id.
	 */
	private String actionSetId;

	/**
	 * The configurations.
	 */
	private Queue<DedupConfig> configurations;

	public DedupConfigurationOrchestration() {
	}

	/**
	 * Instantiates a new dedup configuration orchestration.
	 *
	 * @param entity         the entity
	 * @param actionSetId    the action set id
	 * @param configurations the configurations
	 */
	public DedupConfigurationOrchestration(final Entity entity, final String actionSetId, final Queue<DedupConfig> configurations) {
		super();
		this.setEntity(entity);
		this.setActionSetId(actionSetId);
		this.setConfigurations(configurations);
	}

	/**
	 * From json.
	 *
	 * @param json the json
	 * @return the dedup configuration orchestration
	 */
	public static DedupConfigurationOrchestration fromJSON(final String json) {
		return new Gson().fromJson(json, DedupConfigurationOrchestration.class);
	}

	/**
	 * Gets the entity.
	 *
	 * @return the entity
	 */
	public Entity getEntity() {
		return entity;
	}

	public void setEntity(final Entity entity) {
		this.entity = entity;
	}

	/**
	 * Gets the action set id.
	 *
	 * @return the action set id
	 */
	public String getActionSetId() {
		return actionSetId;
	}

	public void setActionSetId(final String actionSetId) {
		this.actionSetId = actionSetId;
	}

	/**
	 * Gets the configurations.
	 *
	 * @return the configurations
	 */
	public Queue<DedupConfig> getConfigurations() {
		return configurations;
	}

	public void setConfigurations(final Queue<DedupConfig> configurations) {
		this.configurations = configurations;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return new GsonBuilder().setPrettyPrinting().create().toJson(this);
	}

}
