package eu.dnetlib.msro.workflows.nodes.hadoop;

import java.util.Set;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(CreateHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private boolean reuseRegionInfo = false;

	@Override
	protected String execute(final Env env) throws Exception {
		final Set<String> columns = getColumns(env);

		log.info("Ensuring table " + getTableName() + " on cluster: '" + getCluster() + "' - columns: " + columns);

		final HadoopService hadoopService = getServiceLocator().getService(HadoopService.class);
		log.info(String.format("reuse region info: %s", isReuseRegionInfo()));
		if (isReuseRegionInfo()) {
			final String jsonConf = env.getAttribute(getTableConfigurationParamName(), String.class);
			log.debug(String.format("region info: %s", jsonConf));
			if (StringUtils.isBlank(jsonConf)) {
				throw new MSROException("cannot find HBase table configuration in workflow env");
			}

			hadoopService.createConfiguredHbaseTable(getCluster(), getTableName(), jsonConf);
		} else {
			hadoopService.createHbaseTable(getCluster(), getTableName(), columns);
		}
		return Arc.DEFAULT_ARC;
	}

	public boolean isReuseRegionInfo() {
		return reuseRegionInfo;
	}

	public void setReuseRegionInfo(final boolean reuseRegionInfo) {
		this.reuseRegionInfo = reuseRegionInfo;
	}

}
