package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupSimilarityToActionsJobNode extends DedupConfigurationLoaderJobNode {

	private static final Log log = LogFactory.getLog(DedupSimilarityToActionsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String entityType;

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		super.prepareJob(job, token);

		final String entityType = getEntityType();
		if (StringUtils.isBlank(entityType))
			throw new MSROException("unable to find wf param: entityType");

		String cf = "_isSimilarTo";
		switch (Type.valueOf(entityType)) {

		case organization:
			cf = "organization_organization" + cf;
			break;
		case person:
			cf = "person_person" + cf;
			break;
		case publication:
			cf = "publication_publication" + cf;
			break;
		case dataset:
			cf = "dataset_dataset" + cf;
			break;
		case unknown:
			cf = "unknown_unknown" + cf;
			break;
		default:
			throw new MSROException("invalid parameter entityType: " + entityType);
		}

		log.info("using similarity CF: " + cf);
		job.getParameters().put("similarityCF", cf);
		token.getEnv().setAttribute("similarityCF", cf);
	}

	public String getEntityType() {
		return entityType;
	}

	public void setEntityType(final String entityType) {
		this.entityType = entityType;
	}
}
