package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Token;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupDuplicateScanJobNode extends DedupConfigurationAwareJobNode {

	private static final Log log = LogFactory.getLog(DedupDuplicateScanJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new DedupBlackboardWorkflowJobListener(token);
	}

	private class DedupBlackboardWorkflowJobListener extends BlackboardWorkflowJobListener {

		public DedupBlackboardWorkflowJobListener(final Token token) {
			super(token);
		}

		@Override
		protected void onDone(final BlackboardJob job) {

			final DedupConfigurationOrchestration confs = getDedupConfigurationOrchestration();

			confs.getConfigurations().poll();

			log.info("checking dedup configs queue, size: " + confs.getConfigurations().size());

			if (CollectionUtils.isEmpty(confs.getConfigurations())) {
				log.info("dedup similarity scan done");

				if(!job.getParameters().keySet().stream()
						.anyMatch(s -> s.contains("dedup similarity (x2)"))) {
					log.info("dedup couln't find any match");
					getToken().release("noMatch");
				} else {
					getToken().release("done");
				}
			} else {
				log.debug("remaining confs: " + confs);

				getToken().release(Arc.DEFAULT_ARC);
			}
		}
	}

}
