package eu.dnetlib.msro.workflows.nodes.utils;

import java.text.Normalizer;

/**
 * Created by claudio on 14/06/16.
 */
public class CleaningXsltFunctions {

	public static String clean(final String s) {
		return Normalizer.normalize(s, Normalizer.Form.NFD)
				.replaceAll("\\(.+\\)", "")
				.replaceAll("(\\W|\\p{InCombiningDiacriticalMarks}|\\p{Punct}|\\n|\\s)+", "")
				.toLowerCase()
				.trim();
	}
}
