package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DedupConfigurationSetterJobNode extends AsyncJobNode {

	private String dedupConfigSequence;

	private String dedupConfigSequenceParam;

	private String entityTypeNameParam;

	private String entityTypeIdParam;

	@Autowired
	private DedupConfigurationOrchestrationLoader dedupOrchestrationLoader;

	@Override
	protected String execute(final Env env) throws Exception {

		if (StringUtils.isBlank(getDedupConfigSequence())) throw new IllegalArgumentException("missing configuration sequence");

		final DedupConfigurationOrchestration dedupOrchestration = dedupOrchestrationLoader.loadByActionSetId(getDedupConfigSequence());

		env.setAttribute(getEntityTypeNameParam(), dedupOrchestration.getEntity().getName());
		env.setAttribute(getEntityTypeIdParam(), dedupOrchestration.getEntity().getCode());
		env.setAttribute(getDedupConfigSequenceParam(), dedupOrchestration);

		return Arc.DEFAULT_ARC;
	}

	public String getDedupConfigSequence() {
		return dedupConfigSequence;
	}

	public void setDedupConfigSequence(final String dedupConfigSequence) {
		this.dedupConfigSequence = dedupConfigSequence;
	}

	public String getDedupConfigSequenceParam() {
		return dedupConfigSequenceParam;
	}

	public void setDedupConfigSequenceParam(final String dedupConfigSequenceParam) {
		this.dedupConfigSequenceParam = dedupConfigSequenceParam;
	}

	public String getEntityTypeNameParam() {
		return entityTypeNameParam;
	}

	public void setEntityTypeNameParam(final String entityTypeNameParam) {
		this.entityTypeNameParam = entityTypeNameParam;
	}

	public String getEntityTypeIdParam() {
		return entityTypeIdParam;
	}

	public void setEntityTypeIdParam(final String entityTypeIdParam) {
		this.entityTypeIdParam = entityTypeIdParam;
	}
}
