/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.nodes.utils.Similarity;
import eu.dnetlib.msro.workflows.nodes.utils.SimilarityMeshBuilder;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class BuildSimilarityMeshJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(BuildSimilarityMeshJobNode.class);
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private ResultSetFactory resultSetFactory;
    private StringTemplate similarity;
    private String inputEprParam;
    private String outputEprParam;

    protected String execute(Env env) throws Exception {
        ResultSet inputRs = (ResultSet)env.getAttribute(this.getInputEprParam(), ResultSet.class);
        final Iterator it = this.resultSetClient.iter(inputRs, String.class).iterator();
        final LinkedBlockingQueue queue = Queues.newLinkedBlockingQueue();
        final SAXReader reader = new SAXReader();
        if (it.hasNext()) {
            this.populateQueue(queue, reader, (String)it.next());
        }
        ResultSet rsOut = this.resultSetFactory.createResultSet(() -> new Iterator<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Queue queue2 = queue;
                synchronized (queue2) {
                    return !queue.isEmpty();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String next() {
                Queue queue2 = queue;
                synchronized (queue2) {
                    Object o = queue.poll();
                    while (queue.isEmpty() && it.hasNext()) {
                        BuildSimilarityMeshJobNode.this.populateQueue(queue, reader, (String)it.next());
                    }
                    return BuildSimilarityMeshJobNode.this.buildSimilarity((Similarity)o);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
        env.setAttribute(this.getOutputEprParam(), (Object)rsOut);
        return Arc.DEFAULT_ARC;
    }

    private void populateQueue(Queue<Object> q, SAXReader r, String xml) {
        try {
            Document d = r.read((Reader)new StringReader(xml));
            String groupid = d.valueOf("//FIELD[@name='id']");
            List items = d.selectNodes("//FIELD[@name='group']/ITEM");
            String entitytype = d.valueOf("//FIELD[@name='entitytype']");
            ArrayList group = Lists.newArrayList();
            for (Object id : items) {
                group.add(((Node)id).getText());
            }
            TypeProtos.Type type = TypeProtos.Type.valueOf((String)entitytype);
            List<Similarity> mesh = SimilarityMeshBuilder.build(type, group);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("built mesh for group '%s', size %d", groupid, mesh.size()));
            }
            for (Similarity s : mesh) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("adding to queue: %s", s.toString()));
                }
                q.add(s);
            }
        }
        catch (DocumentException e) {
            log.error((Object)("invalid document: " + xml));
        }
    }

    private String buildSimilarity(Similarity s) {
        StringTemplate template = new StringTemplate(this.getSimilarity().getTemplate());
        template.setAttribute("source", s.getPair().getKey());
        template.setAttribute("target", s.getPair().getValue());
        template.setAttribute("type", (Object)s.getType().toString());
        String res = template.toString();
        return res;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public StringTemplate getSimilarity() {
        return this.similarity;
    }

    @Required
    public void setSimilarity(StringTemplate similarity) {
        this.similarity = similarity;
    }
}

