package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by claudio on 28/10/2016.
 */
public class DefineHBaseSchemaJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(DefineHBaseSchemaJobNode.class);

	private String schema;

	@Override
	protected String execute(final Env env) throws Exception {

		log.info("table definition: " + getSchema());
		env.setAttribute(getTableColumnsParamName(), getSchema());

		return Arc.DEFAULT_ARC;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(final String schema) {
		this.schema = schema;
	}
}
