/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.nodes.dedup.DedupConfigurationAwareJobNode;
import eu.dnetlib.msro.workflows.nodes.dedup.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.procs.Token;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupDuplicateScanJobNode
extends DedupConfigurationAwareJobNode {
    private static final Log log = LogFactory.getLog(DedupDuplicateScanJobNode.class);

    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new DedupBlackboardWorkflowJobListener(token);
    }

    private class DedupBlackboardWorkflowJobListener
    extends BlackboardWorkflowJobListener {
        public DedupBlackboardWorkflowJobListener(Token token) {
            super(token);
        }

        protected void onDone(BlackboardJob job) {
            DedupConfigurationOrchestration confs = DedupDuplicateScanJobNode.this.getDedupConfigurationOrchestration();
            confs.getConfigurations().poll();
            log.info((Object)("checking dedup configs queue, size: " + confs.getConfigurations().size()));
            if (CollectionUtils.isEmpty(confs.getConfigurations())) {
                log.info((Object)"dedup similarity scan done");
                if (!job.getParameters().keySet().stream().anyMatch(s -> s.contains("dedup similarity (x2)"))) {
                    log.info((Object)"dedup couln't find any match");
                    this.getToken().release("noMatch");
                } else {
                    this.getToken().release("done");
                }
            } else {
                log.debug((Object)("remaining confs: " + confs));
                this.getToken().release(Arc.DEFAULT_ARC);
            }
        }
    }
}

