/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryUserActionDbJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(QueryUserActionDbJobNode.class);
    private String db;
    private String sql;
    private String sqlForSize;
    private String xslt;
    private String outputEprParam;
    private String dedupConfigSequence;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected String execute(Env env) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getDedupConfigSequence())) {
            throw new IllegalArgumentException("empty action set id");
        }
        String sqlText = String.format(this.readFromClasspath(this.getSql()), this.getDedupConfigSequence());
        log.debug((Object)("executing query: " + sqlText));
        String sqlTextForsize = String.format(StringUtils.isBlank((CharSequence)this.getSqlForSize()) ? "" : this.readFromClasspath(this.getSqlForSize()), this.getDedupConfigSequence());
        if (!sqlTextForsize.isEmpty()) {
            log.debug((Object)("using sql for size: " + sqlTextForsize));
        }
        ResultSet rs = null;
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        if (StringUtils.isNotBlank((CharSequence)this.getXslt())) {
            String xsltText = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.getXslt()));
            rs = StringUtils.isBlank((CharSequence)this.getSqlForSize()) ? dbService.xsltSearchSQL(this.getDb(), sqlText, xsltText) : dbService.alternativeXsltSearchSQL(this.getDb(), sqlText, sqlTextForsize, xsltText);
        } else {
            rs = StringUtils.isBlank((CharSequence)this.getSqlForSize()) ? dbService.searchSQL(this.getDb(), sqlText) : dbService.alternativeSearchSQL(this.getDb(), sqlText, sqlTextForsize);
        }
        log.info((Object)String.format("generated resultset '%s', baseURL: %s", rs.getId(), rs.getBaseUrl()));
        env.setAttribute(this.getOutputEprParam(), (Object)rs);
        return Arc.DEFAULT_ARC;
    }

    private String readFromClasspath(String path) throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(path));
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getSqlForSize() {
        return this.sqlForSize;
    }

    public void setSqlForSize(String sqlForSize) {
        this.sqlForSize = sqlForSize;
    }

    public String getDedupConfigSequence() {
        return this.dedupConfigSequence;
    }

    public void setDedupConfigSequence(String dedupConfigSequence) {
        this.dedupConfigSequence = dedupConfigSequence;
    }
}

