/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.dedup.DedupConfigurationLoaderJobNode;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupSimilarityToActionsJobNode
extends DedupConfigurationLoaderJobNode {
    private static final Log log = LogFactory.getLog(DedupSimilarityToActionsJobNode.class);
    private String entityType;

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        super.prepareJob(job, token);
        String entityType = this.getEntityType();
        if (StringUtils.isBlank((CharSequence)entityType)) {
            throw new MSROException("unable to find wf param: entityType");
        }
        String cf = "_isSimilarTo";
        switch (TypeProtos.Type.valueOf((String)entityType)) {
            case organization: {
                cf = "organization_organization" + cf;
                break;
            }
            case person: {
                cf = "person_person" + cf;
                break;
            }
            case publication: {
                cf = "publication_publication" + cf;
                break;
            }
            case dataset: {
                cf = "dataset_dataset" + cf;
                break;
            }
            case unknown: {
                cf = "unknown_unknown" + cf;
                break;
            }
            default: {
                throw new MSROException("invalid parameter entityType: " + entityType);
            }
        }
        log.info((Object)("using similarity CF: " + cf));
        job.getParameters().put("similarityCF", cf);
        token.getEnv().setAttribute("similarityCF", (Object)cf);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

