package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;

/**
 * Created by claudio on 31/01/2017.
 */
public class FetchOntologiesJobNode extends AsyncJobNode {

	private String ontologiesParamName;

	@Override
	protected String execute(final Env env) throws Exception {

		final Ontologies o = OntologyLoader.loadOntologiesFromIS();

		env.setAttribute(getOntologiesParamName(), o.toJson());

		return Arc.DEFAULT_ARC;
	}

	public String getOntologiesParamName() {
		return ontologiesParamName;
	}

	public void setOntologiesParamName(final String ontologiesParamName) {
		this.ontologiesParamName = ontologiesParamName;
	}
}
