package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.hadoop.SubmitHadoopJobNode;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.pace.config.DedupConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import static eu.dnetlib.msro.workflows.nodes.dedup.DedupConfigurationAwareJobNode.DEDUP_CONF;

public class DedupConfigurationLoaderJobNode extends SubmitHadoopJobNode {

	private static final Log log = LogFactory.getLog(DedupConfigurationLoaderJobNode.class);

	private String dedupConfigSequence;

	@Autowired
	private DedupConfigurationOrchestrationLoader dedupOrchestrationLoader;

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		super.prepareJob(job, token);

		final DedupConfigurationOrchestration dedupOrchestration = dedupOrchestrationLoader.loadByActionSetId(getDedupConfigSequence());
		final DedupConfig currentConf = dedupOrchestration.getConfigurations().peek();

		log.debug("using dedup configuration: '" + currentConf + "'");

		job.getParameters().put(DEDUP_CONF, currentConf.toString());
	}

	public String getDedupConfigSequence() {
		return dedupConfigSequence;
	}

	public void setDedupConfigSequence(final String dedupConfigSequence) {
		this.dedupConfigSequence = dedupConfigSequence;
	}

}
