package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * The Class DropHBaseTableJobNode.
 */
public class DropHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	/**
	 * The Constant log.
	 */
	private static final Log log = LogFactory.getLog(DropHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final Env env) throws Exception {

		log.info("Dropping hbase table '" + getTableName() + "' on cluster: '" + getCluster() + "'");

		getServiceLocator().getService(HadoopService.class).dropHbaseTable(getCluster(), getTableName());

		return Arc.DEFAULT_ARC;
	}

}
