/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.dedup.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.dedup.DedupConfigurationOrchestrationLoader;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DedupCheckEntitySequenceJobNode
extends SimpleJobNode {
    public static final String DEDUP_GROUPER_LOOPER = "dedup.grouper.looper";
    private static final Log log = LogFactory.getLog(DedupCheckEntitySequenceJobNode.class);
    @Autowired
    private DedupConfigurationOrchestrationLoader dedupOrchestrationLoader;
    private String dedupConfigSequenceParam;
    private String entitySequence;
    private String entityTypeNameParam;
    private String entityTypeIdParam;
    private String actionSetParam;

    protected String execute(Env env) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getEntitySequence())) {
            throw new MSROException("missing entity sequence, e.g. a csv: organization,person,result");
        }
        if (env.hasAttribute(DEDUP_GROUPER_LOOPER)) {
            log.info((Object)"reset env variable: dedup.grouper.looper to zero");
            env.setAttribute(DEDUP_GROUPER_LOOPER, (Object)0);
        }
        if (!env.hasAttribute("entitySequence")) {
            log.info((Object)("parsing config sequence: " + this.getEntitySequence()));
            env.setAttribute("entitySequence", (Object)this.getEntitySequence());
            Iterable sequence = Splitter.on((String)",").omitEmptyStrings().split((CharSequence)this.getEntitySequence());
            LinkedList q = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)sequence, entityName -> {
                try {
                    DedupConfigurationOrchestration dco = (DedupConfigurationOrchestration)Iterables.getFirst(this.dedupOrchestrationLoader.loadByEntityName((String)entityName), null);
                    if (dco == null) {
                        throw new RuntimeException("unable to find DedupOrchestration profile for entity type: " + entityName);
                    }
                    return dco;
                }
                catch (Throwable e) {
                    throw new RuntimeException("", e);
                }
            }));
            log.info((Object)("built sequence of dedup orchestration profiles, size: " + q.size()));
            DedupConfigurationOrchestration dco = (DedupConfigurationOrchestration)q.remove();
            log.info((Object)("closing mesh for entity: " + dco.getEntity().getName()));
            this.setDedupConfParams(env, dco);
            env.setAttribute("entitySequenceQueue", (Object)q);
            return Arc.DEFAULT_ARC;
        }
        Queue q = (Queue)env.getAttribute("entitySequenceQueue");
        if (!q.isEmpty()) {
            log.info((Object)("remaining dedup orchestration profiles: " + q.size()));
            DedupConfigurationOrchestration dco = (DedupConfigurationOrchestration)q.remove();
            log.info((Object)("closing mesh for entity: " + dco.getEntity().getName()));
            this.setDedupConfParams(env, dco);
            return Arc.DEFAULT_ARC;
        }
        log.info((Object)("completed closing mesh for entities: " + this.getEntitySequence()));
        return "done";
    }

    private void setDedupConfParams(Env env, DedupConfigurationOrchestration dco) {
        env.setAttribute(this.getEntityTypeNameParam(), (Object)dco.getEntity().getName());
        env.setAttribute(this.getEntityTypeIdParam(), (Object)dco.getEntity().getCode());
        env.setAttribute(this.getActionSetParam(), (Object)dco.getActionSetId());
        env.setAttribute(this.getDedupConfigSequenceParam(), (Object)dco);
    }

    public String getEntitySequence() {
        return this.entitySequence;
    }

    public void setEntitySequence(String entitySequence) {
        this.entitySequence = entitySequence;
    }

    public String getDedupConfigSequenceParam() {
        return this.dedupConfigSequenceParam;
    }

    public void setDedupConfigSequenceParam(String dedupConfigSequenceParam) {
        this.dedupConfigSequenceParam = dedupConfigSequenceParam;
    }

    public String getEntityTypeNameParam() {
        return this.entityTypeNameParam;
    }

    public void setEntityTypeNameParam(String entityTypeNameParam) {
        this.entityTypeNameParam = entityTypeNameParam;
    }

    public String getEntityTypeIdParam() {
        return this.entityTypeIdParam;
    }

    public void setEntityTypeIdParam(String entityTypeIdParam) {
        this.entityTypeIdParam = entityTypeIdParam;
    }

    public String getActionSetParam() {
        return this.actionSetParam;
    }

    public void setActionSetParam(String actionSetParam) {
        this.actionSetParam = actionSetParam;
    }
}

