/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHBaseAdminJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(AbstractHBaseAdminJobNode.class);
    private String tableColumnsParamName = "columns";
    private String tableConfigurationParamName = "tableConf";
    private String tableName;
    private String cluster;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected Set<String> getColumns(Env env) throws MSROException {
        String envCols = (String)env.getAttribute(this.getTableColumnsParamName(), String.class);
        if (StringUtils.isBlank((CharSequence)envCols)) {
            throw new MSROException("cannot find table description");
        }
        log.debug((Object)("using columns from env: " + envCols));
        return Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)envCols));
    }

    protected String asCSV(Iterable<String> columns) {
        return Joiner.on((String)",").skipNulls().join(columns);
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getTableColumnsParamName() {
        return this.tableColumnsParamName;
    }

    public void setTableColumnsParamName(String tableColumnsParamName) {
        this.tableColumnsParamName = tableColumnsParamName;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public String getTableConfigurationParamName() {
        return this.tableConfigurationParamName;
    }

    public void setTableConfigurationParamName(String tableConfigurationParamName) {
        this.tableConfigurationParamName = tableConfigurationParamName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

