/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.hadoop.HadoopBlackboardActions;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHBaseJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(AbstractHBaseJobNode.class);
    private final String INPUT_HBASE_TABLE_PARAM = "hbaseTable";
    private final String INPUT_EPR_PARAM = "input_epr";
    private final String INPUT_CLUSTER_PARAM = "cluster";
    private final String XSLT_PARAM = "xslt";
    private final String OUTPUT_HBASE_TABLE_PARAM = "table";
    private final String OUTPUT_CLUSTER_PARAM = "cluster";
    private final String SIMULATION_PARAM = "simulation";
    @Autowired
    protected UniqueServiceLocator serviceLocator;
    @Autowired
    protected ResultSetClient resultSetClient;
    protected String inputEprParam;
    protected String hbaseTable;
    protected String cluster;
    protected String mapping;
    protected boolean simulation = false;

    protected abstract HadoopBlackboardActions getAction();

    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(HadoopService.class);
    }

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        log.info((Object)("Invoking blackboard method: " + this.getAction().toString()));
        ResultSet rs = (ResultSet)token.getEnv().getAttribute(this.getInputEprParam(), ResultSet.class);
        token.setProgressProvider((ProgressProvider)new ResultsetProgressProvider(rs, this.resultSetClient));
        job.setAction(this.getAction().toString());
        job.getParameters().put("input_epr", rs.toJson());
        job.getParameters().put("xslt", DnetXsltFunctions.encodeBase64((String)this.readXslt(this.getMapping())));
        job.getParameters().put("table", this.getHbaseTable());
        job.getParameters().put("cluster", this.getCluster());
        job.getParameters().put("simulation", String.valueOf(this.isSimulation()));
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token){

            protected void responseToEnv(Env env, Map<String, String> responseParams) {
                String count = responseParams.get("count");
                log.info((Object)String.format("%s %s objects to HBase table %s, cluster %s", AbstractHBaseJobNode.this.getAction().toString(), count, AbstractHBaseJobNode.this.getHbaseTable(), AbstractHBaseJobNode.this.getCluster()));
                env.setAttribute("mainlog:" + AbstractHBaseJobNode.this.getNodeName() + ":count", (Object)count);
            }
        };
    }

    private String readXslt(String profileId) throws IOException, MSROException, ISLookUpException {
        if (StringUtils.isBlank((CharSequence)profileId)) {
            throw new MSROException("missing profile id");
        }
        log.info((Object)("loading mapping from profile id: " + profileId));
        String xquery = String.format("/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='%s']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']", profileId);
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    public String getHbaseTable() {
        return this.hbaseTable;
    }

    public void setHbaseTable(String hbaseTable) {
        this.hbaseTable = hbaseTable;
    }
}

