package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExistHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(ExistHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final Env env) throws Exception {

		log.info("checking table existance: '" + getTableName() + "' on cluster: '" + getCluster() + "'");

		final HadoopService hadoopService = getServiceLocator().getService(HadoopService.class);
		boolean exists = hadoopService.existHbaseTable(getCluster(), getTableName());

		log.info("table '" + getTableName() + "' exists: " + exists);

		if (exists) {
			final String tableDesc = hadoopService.describeHBaseTableConfiguration(getCluster(), getTableName());
			env.setAttribute(getTableConfigurationParamName(), tableDesc);
		}

		return exists ? "drop" : "define";
	}

}
