/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.hadoop.HadoopBlackboardActions;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StoreHdfsRecordsJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(StoreHdfsRecordsJobNode.class);
    private String inputEprParam;
    private String hdfsPath;
    private String cluster;
    @Autowired
    private ResultSetClient resultSetClient;

    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(HadoopService.class);
    }

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        log.info((Object)"Invoking blackboard method");
        ResultSet rs = (ResultSet)token.getEnv().getAttribute(this.inputEprParam, ResultSet.class);
        token.setProgressProvider((ProgressProvider)new ResultsetProgressProvider(rs, this.resultSetClient));
        job.setAction(HadoopBlackboardActions.IMPORT_EPR_HDFS.toString());
        job.getParameters().put("input_epr", rs.toJson());
        job.getParameters().put("path", this.getHdfsPath());
        job.getParameters().put("cluster", this.getCluster());
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token){

            protected void responseToEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:" + StoreHdfsRecordsJobNode.this.getNodeName() + ":count", (Object)responseParams.get("count"));
            }
        };
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getHdfsPath() {
        return this.hdfsPath;
    }

    public void setHdfsPath(String hdfsPath) {
        this.hdfsPath = hdfsPath;
    }
}

