/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import com.google.common.collect.Iterables;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.hadoop.HadoopBlackboardActions;
import eu.dnetlib.rmi.data.hadoop.HadoopJobType;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubmitHadoopJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(SubmitHadoopJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String hadoopJob;
    private String cluster;
    private boolean simulation = false;
    private Map<String, Object> jobParams = new HashMap<String, Object>();

    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(HadoopService.class);
    }

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        String type = this.getJobType(this.getHadoopJob());
        log.info((Object)("submitting job " + this.getHadoopJob() + " type: " + type));
        job.setAction(type);
        job.getParameters().put("job.name", this.getHadoopJob());
        job.getParameters().put("cluster", this.cluster(token));
        job.getParameters().put("simulation", String.valueOf(this.isSimulation()));
        for (Map.Entry<String, Object> e : this.getJobParams().entrySet()) {
            try {
                job.getParameters().put(e.getKey(), e.getValue().toString());
            }
            catch (Throwable ex) {
                throw new MSROException(String.format("missing value for map key '%s'", e.getKey()));
            }
        }
    }

    private String cluster(Token token) {
        if (token.getEnv().hasAttribute("cluster")) {
            String cluster = (String)token.getEnv().getAttribute("cluster", String.class);
            log.info((Object)("found override value in wfEnv for 'cluster' param: " + cluster));
            return cluster;
        }
        return this.getCluster();
    }

    private String getJobType(String jobName) throws ISLookUpException {
        List res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'HadoopJobConfigurationDSResourceType']//HADOOP_JOB[./@name='" + jobName + "']/@type/string()");
        if (res.isEmpty()) {
            throw new IllegalStateException("unable to find job type for job: " + jobName);
        }
        HadoopJobType type = HadoopJobType.valueOf((String)((String)Iterables.getOnlyElement((Iterable)res)));
        switch (type) {
            case mapreduce: {
                return HadoopBlackboardActions.SUBMIT_MAPREDUCE_JOB.toString();
            }
            case admin: {
                return HadoopBlackboardActions.SUBMIT_ADMIN_JOB.toString();
            }
            case oozie: {
                return HadoopBlackboardActions.SUBMIT_OOZIE_JOB.toString();
            }
        }
        throw new IllegalStateException("undefined job type: " + type.toString());
    }

    public String getHadoopJob() {
        return this.hadoopJob;
    }

    public void setHadoopJob(String hadoopJob) {
        this.hadoopJob = hadoopJob;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    public Map<String, Object> getJobParams() {
        return this.jobParams;
    }

    public void setJobParams(Map<String, Object> jobParams) {
        this.jobParams = jobParams;
    }
}

