package eu.dnetlib.data.actionmanager.blackboard;

import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by claudio on 13/06/16.
 */
public class ActionManagerBlackboardJobListener extends AbstractBlackboardJobListener {

	private static final Log log = LogFactory.getLog(ActionManagerBlackboardJobListener.class);

	private ActionManagerBlackboardCallback callback;

	public ActionManagerBlackboardJobListener(final ActionManagerBlackboardCallback callback) {
		super();
		this.callback = callback;
	}

	@Override
	protected void onDone(final BlackboardJob job) {
		try {
			if (callback != null) {
				callback.onDone(job.getParameters());
			}
		} catch (Exception e) {
			log.error("fail to run a callback function");
		}
	}

	@Override
	protected void onFailed(final BlackboardJob job) {
		try {
			if (callback != null) {
				callback.onFailed(new ActionManagerException(job.getError()));
			}
		} catch (Exception e) {
			log.error("fail to run a callback function");
		}
	}

}
