package eu.dnetlib.data.hadoop.blackboard;

import eu.dnetlib.data.hadoop.HadoopServiceCore;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Delete a path on hdfs.
 *
 * Params - cluster: cluster name, path: the path to deleteFromHBase recursively
 *
 * @author claudio
 *
 */
public class DeleteHdfsPathAction extends AbstractHadoopAction {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(DeleteHdfsPathAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * The hadoop service core.
	 */
	@Autowired
	private HadoopServiceCore hadoopServiceCore;

	@Override
	protected void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws HadoopServiceException {
		final ClusterName clusterName = ClusterName.valueOf(job.getParameters().get("cluster"));
		log.info("deleteFromHBase request on cluster: " + clusterName.toString());

		final String path = job.getParameters().get("path");
		hadoopServiceCore.deleteFromHdfs(clusterName, path);

		handler.done(job);
	}

}
