/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.data.hadoop.HadoopServiceCore;
import eu.dnetlib.data.hadoop.JobRegistry;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopJobDescriptor;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import eu.dnetlib.rmi.data.hadoop.hbase.HBaseRowDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class HadoopServiceImpl
extends AbstractBaseService
implements HadoopService {
    private NotificationHandler notificationHandler;
    @Autowired
    private HadoopServiceCore hadoopServiceCore;
    @Autowired
    private JobRegistry jobRegistry;

    public List<String> listAvailableJobs() throws HadoopServiceException {
        ArrayList res = Lists.newArrayList();
        return res;
    }

    public List<HadoopJobDescriptor> listJobs(String clusterName) throws HadoopServiceException {
        return this.jobRegistry.listJobs(this.checkExists(clusterName));
    }

    public boolean killJob(String jobId) throws HadoopServiceException {
        this.jobRegistry.unregisterJob(jobId);
        return true;
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public List<String> listHbaseTables(String clusterName) throws HadoopServiceException {
        try {
            return this.hadoopServiceCore.listTables(this.checkExists(clusterName));
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean ensureHbaseTable(String clusterName, String tableName, Set<String> columns) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.ensureTable(this.checkExists(clusterName), tableName, columns);
            return true;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean createHbaseTable(String clusterName, String tableName, Set<String> columns) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.createTable(this.checkExists(clusterName), tableName, columns);
            return true;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean createConfiguredHbaseTable(String clusterName, String tableName, String tableConfiguration) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.createTable(this.checkExists(clusterName), tableName, tableConfiguration);
            return true;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean truncateHbaseTable(String clusterName, String tableName) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.truncateTable(this.checkExists(clusterName), tableName);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
        return true;
    }

    public boolean dropHbaseTable(String clusterName, String tableName) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.dropTable(this.checkExists(clusterName), tableName);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
        return true;
    }

    public boolean existHbaseTable(String clusterName, String tableName) throws HadoopServiceException {
        try {
            return this.hadoopServiceCore.existTable(this.checkExists(clusterName), tableName);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public Map<String, String> getClusterConfiguration(String clusterName) throws HadoopServiceException {
        Configuration conf = this.hadoopServiceCore.getClusterConiguration(this.checkExists(clusterName));
        HashMap res = Maps.newHashMap();
        for (Map.Entry e : conf) {
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    public boolean deleteHdfsPath(String clusterName, String path) throws HadoopServiceException {
        return this.hadoopServiceCore.deleteFromHdfs(this.checkExists(clusterName), path);
    }

    public boolean existHdfsPath(String clusterName, String path) throws HadoopServiceException {
        return this.hadoopServiceCore.existHdfsPath(this.checkExists(clusterName), path);
    }

    public boolean createHdfsDirectory(String clusterName, String path, boolean force) throws HadoopServiceException {
        return this.hadoopServiceCore.createHdfsDir(this.checkExists(clusterName), path, force);
    }

    public List<String> listClusters() throws HadoopServiceException {
        try {
            return ClusterName.asStringList();
        }
        catch (Throwable e) {
            throw new HadoopServiceException(e);
        }
    }

    public List<String> describeHbaseTable(String clusterName, String tableName) throws HadoopServiceException {
        try {
            return this.hadoopServiceCore.describeTable(this.checkExists(clusterName), tableName);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public HBaseRowDescriptor describeHBaseColumn(String clusterName, String tableName, String rowKey) throws HadoopServiceException {
        try {
            return this.hadoopServiceCore.describeRow(this.checkExists(clusterName), tableName, rowKey);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public Map<String, HBaseRowDescriptor> describeHBaseColumns(String clusterName, String tableName, List<String> rowKeys) throws HadoopServiceException {
        try {
            return this.hadoopServiceCore.describeRows(this.checkExists(clusterName), tableName, rowKeys);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public String describeHBaseTableConfiguration(String clusterName, String tableName) throws HadoopServiceException {
        try {
            return this.hadoopServiceCore.getHBaseTableDescriptor(this.checkExists(clusterName), tableName);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean deleteHBaseColumn(String clusterName, String tableName, HBaseRowDescriptor column) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.deleteColumnsFromHBase(this.checkExists(clusterName), tableName, Lists.newArrayList((Object[])new HBaseRowDescriptor[]{column}));
            return true;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean deleteHBaseColumns(String clusterName, String tableName, List<HBaseRowDescriptor> column) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.deleteColumnsFromHBase(this.checkExists(clusterName), tableName, column);
            return true;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    private ClusterName checkExists(String clusterName) throws HadoopServiceException {
        try {
            return ClusterName.valueOf((String)clusterName);
        }
        catch (IllegalArgumentException e) {
            throw new HadoopServiceException("Invalid cluster name: " + clusterName);
        }
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }
}

