package eu.dnetlib.data.hadoop.hbase;

import eu.dnetlib.rmi.data.hadoop.ClusterName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;

public class HBaseAdminFactory {

	private static final Log log = LogFactory.getLog(HBaseAdminFactory.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private ConfigurationEnumerator configurationEnumerator;

	public HBaseAdmin newInstance(final ClusterName clusterName) throws HadoopServiceException {
		try {
			log.info("init hbaseAdmin, cluster: " + clusterName.toString());
			return new HBaseAdmin(configurationEnumerator.get(clusterName));
		} catch (final Throwable e) {
			log.warn("unable to initialize hbase client for cluster: " + clusterName.toString(), e);
			return null;
		}
	}
}
