package eu.dnetlib.data.hadoop.hbase;

import java.util.List;

import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

/**
 * The Class HBaseDeleteFeeder performs a batch of Delete operations.
 */
public class HBaseDeleteFeeder extends HbaseTableFeeder {

	/**
	 * Logger.
	 */
	private static final Log log = LogFactory.getLog(HBaseDeleteFeeder.class); // NOPMD by marko on 11/24/08 5:02 PM

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.data.hadoop.hbase.HbaseTableFeeder#addOperation(java.util.List, eu.dnetlib.data.transform.Row)
	 */
	@Override
	protected void addOperation(final List<Mutation> buffer, final Row row) {
		final Delete delete = new Delete(Bytes.toBytes(row.getKey()));
		delete.setWriteToWAL(true);

		for (final Column<String, byte[]> col : row) {
			log.debug(String.format("deleting K: '%s' CF:'%s' Q:'%s'", row.getKey(), row.getColumnFamily(), col.getName()));
			delete.deleteColumns(Bytes.toBytes(row.getColumnFamily()), Bytes.toBytes(col.getName()));
		}

		buffer.add(delete);
	}

}
