/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.actionmanager;

import eu.dnetlib.data.hadoop.HadoopIsClient;
import eu.dnetlib.data.hadoop.HadoopServiceCore;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerException;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerService;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerSet;
import java.util.List;
import javax.jws.WebParam;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ActionManagerServiceImpl
extends AbstractBaseService
implements ActionManagerService {
    @Autowired
    private HadoopIsClient isClient;
    private NotificationHandler notificationHandler;
    @Autowired
    private HadoopServiceCore hadoopServiceCore;

    public String createSet(@WebParam(name="set") ActionManagerSet set) throws ActionManagerException {
        try {
            String basePath = this.isClient.getBasePathHDFS();
            Path actionSetPath = new Path(basePath + "/" + set.getId());
            this.hadoopServiceCore.createHdfsDir(ClusterName.DM, actionSetPath.toString(), true);
            return this.isClient.registerSetProfile(set);
        }
        catch (HadoopServiceException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public boolean deleteSet(@WebParam(name="set") String setId) throws ActionManagerException {
        try {
            String basePath = this.isClient.getBasePathHDFS();
            Path actionSetPath = new Path(basePath + "/" + setId);
            this.hadoopServiceCore.deleteFromHdfs(ClusterName.DM, actionSetPath.toString());
            return this.isClient.deleteSetProfile(setId);
        }
        catch (HadoopServiceException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public List<ActionManagerSet> ListSets() throws ActionManagerException {
        return this.isClient.listSets();
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }
}

