/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.blackboard;

import eu.dnetlib.data.hadoop.HadoopJob;
import eu.dnetlib.data.hadoop.blackboard.AbstractSubmitAction;
import eu.dnetlib.data.hadoop.blackboard.JobCompletion;
import eu.dnetlib.data.hadoop.oozie.OozieJobMonitor;
import eu.dnetlib.data.hadoop.utils.JobProfile;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;

public class SubmitOozieJobAction
extends AbstractSubmitAction {
    private static final Log log = LogFactory.getLog(SubmitOozieJobAction.class);

    @Override
    public void submit(JobCompletion callback, BlackboardJob bbJob, String jobName, JobProfile jobProfile) throws HadoopServiceException {
        ClusterName clusterName = ClusterName.valueOf((String)((String)bbJob.getParameters().get("cluster")));
        try {
            Properties jobConf = this.prepareJob(this.getConf(clusterName), jobName, jobProfile, bbJob.getParameters());
            log.debug((Object)("oozie job configuration:\n" + jobConf));
            if (!this.hadoopClientMap.isOozieAvailable(clusterName)) {
                throw new HadoopServiceException("oozie not available for cluster: " + clusterName.toString());
            }
            this.logJobDetails(jobConf);
            OozieClient oozieClient = this.hadoopClientMap.getOozieClient(clusterName);
            String internalId = oozieClient.run(jobConf);
            String jobId = this.newJobId(clusterName, internalId);
            this.jobRegistry.registerJob(HadoopJob.newInstance(jobId, clusterName, jobProfile, new OozieJobMonitor(oozieClient, internalId, callback)));
        }
        catch (OozieClientException e) {
            throw new HadoopServiceException("error executing hadoop job: " + jobName, (Throwable)e);
        }
    }

    private Properties prepareJob(Configuration configuration, String jobName, JobProfile jobProfile, Map<String, String> parameters) {
        log.info((Object)("creating job: " + jobName));
        Properties p = new Properties();
        this.merge(p, (Iterable<Map.Entry<String, String>>)configuration);
        this.merge(p, jobProfile.getJobDefinition().entrySet());
        this.merge(p, parameters.entrySet());
        return p;
    }

    private void merge(Properties p, Iterable<Map.Entry<String, String>> entrySet) {
        for (Map.Entry<String, String> e : entrySet) {
            p.setProperty(e.getKey(), e.getValue());
        }
    }

    protected void logJobDetails(Properties jobConf) {
        for (Map.Entry<Object, Object> e : jobConf.entrySet()) {
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\n" + e.getKey().toString() + " : " + e.getValue().toString()));
        }
    }
}

