/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.hbase;

import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.springframework.beans.factory.annotation.Autowired;

public class HBaseAdminFactory {
    private static final Log log = LogFactory.getLog(HBaseAdminFactory.class);
    @Autowired
    private ConfigurationEnumerator configurationEnumerator;

    public HBaseAdmin newInstance(ClusterName clusterName) throws HadoopServiceException {
        try {
            log.info((Object)("init hbaseAdmin, cluster: " + clusterName.toString()));
            return new HBaseAdmin(this.configurationEnumerator.get(clusterName));
        }
        catch (Throwable e) {
            log.warn((Object)("unable to initialize hbase client for cluster: " + clusterName.toString()), e);
            return null;
        }
    }
}

