/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.springframework.beans.factory.annotation.Required;

public class SequenceFileWriterFactory {
    private Class<? extends Writable> keyClass;
    private Class<? extends Writable> valueClass;
    private String compressionType;
    private String blockSize = "64M";
    private short replication = (short)3;

    public SequenceFile.Writer getSequenceFileWriter(Class<? extends Writable> keyClass, Class<? extends Writable> valueClass, Configuration conf, Path sequenceFilePath) throws IOException {
        Configuration newConf = new Configuration(conf);
        newConf.set("dfs.blocksize", this.getBlockSize());
        SequenceFile.Writer.Option oFile = SequenceFile.Writer.file((Path)sequenceFilePath);
        SequenceFile.Writer.Option oKey = SequenceFile.Writer.keyClass(keyClass);
        SequenceFile.Writer.Option oValue = SequenceFile.Writer.valueClass(valueClass);
        SequenceFile.Writer.Option oCmp = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.valueOf((String)this.getCompressionType()));
        SequenceFile.Writer.Option oRpl = SequenceFile.Writer.replication((short)this.getReplication());
        return SequenceFile.createWriter((Configuration)newConf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{oFile, oKey, oValue, oCmp, oRpl});
    }

    public SequenceFile.Writer getSequenceFileWriter(Configuration conf, Path sequenceFilePath) throws IOException {
        return this.getSequenceFileWriter(this.getKeyClass(), this.getValueClass(), conf, sequenceFilePath);
    }

    public Class<? extends Writable> getKeyClass() {
        return this.keyClass;
    }

    @Required
    public void setKeyClass(Class<? extends Writable> keyClass) {
        this.keyClass = keyClass;
    }

    public Class<? extends Writable> getValueClass() {
        return this.valueClass;
    }

    @Required
    public void setValueClass(Class<? extends Writable> valueClass) {
        this.valueClass = valueClass;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    @Required
    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(String blockSize) {
        this.blockSize = blockSize;
    }

    public short getReplication() {
        return this.replication;
    }

    public void setReplication(short replication) {
        this.replication = replication;
    }
}

