package eu.dnetlib.data.hadoop.blackboard;

import java.io.IOException;

import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class ImportEprHdfsAction extends AbstractHadoopAction {

	private static final Log log = LogFactory.getLog(ImportEprHdfsAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private SequenceFileFeeder sequenceFileFeeder;

	@Override
	public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws HadoopServiceException {

		final String eprJson = job.getParameters().get("input_epr");
		final ResultSet<String> resultSet = (ResultSet<String>) ResultSet.fromJson(eprJson);
		final ClusterName clusterName = ClusterName.valueOf(job.getParameters().get("cluster"));
		final String path = job.getParameters().get("path");

		log.info(String.format("Starting import in hdfs sequence file '%s', cluster '%s'", path, clusterName.toString()));
		try {
			Integer count = sequenceFileFeeder.feed(resultSet, clusterName, path);
			if (count != null) {
				log.info("Import completed successfully");
				job.getParameters().put("count", String.valueOf(count));
			}

			handler.done(job);
		} catch (IOException e) {
			throw new HadoopServiceException("Import failed", e);
		}
	}

}
