/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.actionmanager.blackboard;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.actionmanager.blackboard.AbstractActionManagerAction;
import eu.dnetlib.data.actionmanager.blackboard.ActionManagerActions;
import eu.dnetlib.data.hadoop.HadoopIsClient;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerSet;
import eu.dnetlib.rmi.data.hadoop.actionmanager.RawSet;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GarbageActionManagerActionFromHDFS
extends AbstractActionManagerAction
implements BlackboardServerAction<ActionManagerActions> {
    private static final Log log = LogFactory.getLog(GarbageActionManagerActionFromHDFS.class);
    private static final String UPDATE_ACTION_PROFILE = "for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'ActionManagerSetDSResourceType' and .//SET/@id = '%s'] return update delete $x//RAW_SETS/EXPIRED[@id = '%s']";
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private HadoopIsClient isClient;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) {
        try {
            String basePath = this.isClient.getBasePathHDFS();
            Integer garbageRetain = Integer.valueOf(this.isClient.getGarbageRetainThreshold());
            Long dateLimit = new Date().getTime() - Long.valueOf(this.isClient.getGarbageTimeMargin());
            HadoopService hadoopService = (HadoopService)this.serviceLocator.getService(HadoopService.class);
            ISRegistryService isRegistry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
            for (ActionManagerSet set : this.isClient.listValidSets()) {
                for (RawSet expired : Iterables.limit((Iterable)set.getExpired(), (int)garbageRetain)) {
                    Date d = DateUtils.parseDate((String)expired.getLastUpdate(), (String[])ActionManagerSet.DATE_PATTERNS);
                    if (d.getTime() >= dateLimit) continue;
                    log.info((Object)String.format("removing raw action set %s/%s", set.getId(), expired.getId()));
                    hadoopService.deleteHdfsPath(ClusterName.DM.toString(), basePath + "/" + set.getDirectory() + "/" + expired.getId());
                    String xUpdate = String.format(UPDATE_ACTION_PROFILE, set.getId(), expired.getId());
                    log.info((Object)String.format("updating ActionSet profile: %s", xUpdate));
                    isRegistry.executeXUpdate(xUpdate);
                }
            }
            handler.done(job);
        }
        catch (Throwable e) {
            handler.failed(job, e);
        }
    }
}

