/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.data.hadoop.HadoopClients;
import eu.dnetlib.data.hadoop.hbase.HBaseAdminFactory;
import eu.dnetlib.data.hadoop.mapreduce.JobClientFactory;
import eu.dnetlib.data.hadoop.oozie.OozieClientFactory;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.mapred.JobClient;
import org.apache.oozie.client.OozieClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Lazy;

public class HadoopClientMap {
    private static final Log log = LogFactory.getLog(HadoopClientMap.class);
    @Lazy
    @Autowired
    private JobClientFactory jobClientFactory;
    @Lazy
    @Autowired
    private OozieClientFactory oozieClientFactory;
    @Lazy
    @Autowired
    private HBaseAdminFactory hbaseAdminFactory;
    private int clientsInitTime;
    private Map<String, Map<String, String>> enabledClients = Maps.newHashMap();
    private final Map<ClusterName, HadoopClients> clients = Maps.newHashMap();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void init() {
        log.info((Object)("clients conf: " + this.getEnabledClients()));
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (String name : HadoopClientMap.this.enabledClients.keySet()) {
                    HadoopClientMap.this.doInit(name);
                }
            }
        });
    }

    private void doInit(String name) {
        try {
            log.info((Object)("initializing clients for hadoop cluster: " + name));
            ClusterName clusterName = ClusterName.valueOf((String)name);
            Map<String, String> clientsConf = this.enabledClients.get(name);
            JobClient jobClient = Boolean.valueOf(clientsConf.get("mapred")) != false ? this.getJobClientFactory().newInstance(name) : null;
            OozieClient oozieClient = Boolean.valueOf(clientsConf.get("oozie")) != false ? this.getOozieClientFactory().newInstance(clusterName) : null;
            HBaseAdmin hbaseAdmin = Boolean.valueOf(clientsConf.get("hbase")) != false ? this.getHbaseAdminFactory().newInstance(clusterName) : null;
            this.clients.put(clusterName, new HadoopClients(jobClient, oozieClient, hbaseAdmin));
        }
        catch (Throwable e) {
            log.error((Object)("Error initializing hadoop client for cluster: " + name), e);
            throw new RuntimeException(e);
        }
    }

    public boolean waitClients() throws InterruptedException {
        return this.executor.awaitTermination(this.getClientsInitTime(), TimeUnit.SECONDS);
    }

    public JobClient getJtClient(ClusterName name) {
        return this.getClients(name).getJtClient();
    }

    public boolean isMapreduceAvailable(ClusterName name) {
        return this.getClients(name).isMapredAvailable();
    }

    public OozieClient getOozieClient(ClusterName name) {
        return this.getClients(name).getOozieClient();
    }

    public boolean isOozieAvailable(ClusterName name) {
        return this.getClients(name).isOozieAvailable();
    }

    public HBaseAdmin getHbaseAdmin(ClusterName name) {
        return this.getClients(name).getHbaseAdmin();
    }

    public HadoopClients getClients(ClusterName name) {
        HadoopClients hadoopClients = this.clients.get(name);
        if (hadoopClients == null) {
            throw new IllegalArgumentException("cluster " + name.toString() + " is currently disabled");
        }
        return hadoopClients;
    }

    public String getEnabledClients() {
        return new Gson().toJson(this.enabledClients);
    }

    @Required
    public void setEnabledClients(String enabledClients) {
        this.enabledClients = (Map)new Gson().fromJson(enabledClients, Map.class);
    }

    public JobClientFactory getJobClientFactory() {
        return this.jobClientFactory;
    }

    public void setJobClientFactory(JobClientFactory jobClientFactory) {
        this.jobClientFactory = jobClientFactory;
    }

    public OozieClientFactory getOozieClientFactory() {
        return this.oozieClientFactory;
    }

    public void setOozieClientFactory(OozieClientFactory oozieClientFactory) {
        this.oozieClientFactory = oozieClientFactory;
    }

    public HBaseAdminFactory getHbaseAdminFactory() {
        return this.hbaseAdminFactory;
    }

    public void setHbaseAdminFactory(HBaseAdminFactory hbaseAdminFactory) {
        this.hbaseAdminFactory = hbaseAdminFactory;
    }

    public int getClientsInitTime() {
        return this.clientsInitTime;
    }

    @Required
    public void setClientsInitTime(int clientsInitTime) {
        this.clientsInitTime = clientsInitTime;
    }
}

