/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.blackboard;

import eu.dnetlib.data.hadoop.blackboard.AbstractHadoopAction;
import eu.dnetlib.data.hadoop.blackboard.SequenceFileFeeder;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportEprHdfsAction
extends AbstractHadoopAction {
    private static final Log log = LogFactory.getLog(ImportEprHdfsAction.class);
    @Autowired
    private SequenceFileFeeder sequenceFileFeeder;

    @Override
    public void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws HadoopServiceException {
        String eprJson = (String)job.getParameters().get("input_epr");
        ResultSet resultSet = ResultSet.fromJson((String)eprJson);
        ClusterName clusterName = ClusterName.valueOf((String)((String)job.getParameters().get("cluster")));
        String path = (String)job.getParameters().get("path");
        log.info((Object)String.format("Starting import in hdfs sequence file '%s', cluster '%s'", path, clusterName.toString()));
        try {
            Integer count = this.sequenceFileFeeder.feed((ResultSet<String>)resultSet, clusterName, path);
            if (count != null) {
                log.info((Object)"Import completed successfully");
                job.getParameters().put("count", String.valueOf(count));
            }
            handler.done(job);
        }
        catch (IOException e) {
            throw new HadoopServiceException("Import failed", (Throwable)e);
        }
    }
}

