/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.blackboard;

import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.hdfs.SequenceFileWriterFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class SequenceFileFeeder {
    private static final Log log = LogFactory.getLog(SequenceFileFeeder.class);
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;
    @Autowired
    protected SequenceFileWriterFactory sequenceFileWriterFactory;
    @Autowired
    private ResultSetClient resultSetClient;
    @Value(value="${services.hadoop.hdfs.writer.bulk.size}")
    private int bulkSize;

    public int feed(ResultSet<String> resultSet, ClusterName clusterName, String path) throws IOException {
        return this.doWrite(resultSet, clusterName, path);
    }

    private int doWrite(ResultSet<String> resultSet, ClusterName clusterName, String path) throws IOException {
        try (SequenceFile.Writer writer = this.sequenceFileWriterFactory.getSequenceFileWriter(Text.class, Text.class, this.getConf(clusterName), new Path(path));){
            log.debug((Object)("Opened sequence file writer: " + writer.toString()));
            Text idText = new Text();
            Text bodyText = new Text();
            int count = 0;
            int nulls = 0;
            for (String record : this.resultSetClient.iter(resultSet, String.class)) {
                if (StringUtils.isBlank((CharSequence)record)) {
                    ++nulls;
                    continue;
                }
                idText.set(String.valueOf(count++));
                bodyText.set(record);
                writer.append((Writable)idText, (Writable)bodyText);
                if (count % this.bulkSize != 0) continue;
                writer.hflush();
                writer.hsync();
                log.debug((Object)String.format("%s records so far %s", writer.toString(), count));
            }
            log.info((Object)("written " + count + " records in sequence file: " + path));
            if (nulls > 0) {
                log.warn((Object)("found " + nulls + " records in epr!"));
            }
            int n = count;
            return n;
        }
    }

    protected Configuration getConf(ClusterName clusterName) {
        return this.configurationEnumerator.get(clusterName);
    }
}

