/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.blackboard;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.hadoop.HadoopJob;
import eu.dnetlib.data.hadoop.blackboard.JobCompletion;
import eu.dnetlib.data.hadoop.blackboard.SubmitMapreduceJobAction;
import eu.dnetlib.data.hadoop.mapreduce.MapreduceJobMonitor;
import eu.dnetlib.data.hadoop.utils.JobProfile;
import eu.dnetlib.data.hadoop.utils.ScanProperties;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopJobType;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;

public class SubmitAdminJobAction
extends SubmitMapreduceJobAction {
    private static final Log log = LogFactory.getLog(SubmitAdminJobAction.class);

    @Override
    public void submit(JobCompletion callback, BlackboardJob bbJob, String jobName, JobProfile jobProfile) throws HadoopServiceException {
        ClusterName clusterName = ClusterName.valueOf((String)((String)bbJob.getParameters().get("cluster")));
        try {
            JobConf jobConf = this.prepareJob(this.getConf(clusterName), jobName, jobProfile, bbJob.getParameters());
            jobConf = this.initAdminJob(bbJob, jobName, jobProfile, jobConf);
            if (!this.hadoopClientMap.isMapreduceAvailable(clusterName)) {
                throw new HadoopServiceException("mapreduce not available for cluster: " + clusterName.toString());
            }
            this.logJobDetails(jobConf);
            RunningJob runningJob = this.hadoopClientMap.getJtClient(clusterName).submitJob(jobConf);
            String jobId = this.newJobId(clusterName, runningJob.getID().getId());
            this.jobRegistry.registerJob(HadoopJob.newInstance(jobId, clusterName, jobProfile, new MapreduceJobMonitor(runningJob, callback)));
        }
        catch (IOException e) {
            throw new HadoopServiceException("error executing hadoop job: " + jobName, (Throwable)e);
        }
    }

    private JobConf initAdminJob(BlackboardJob bbJob, String jobName, JobProfile jobProfile, JobConf jobConf) throws IOException, HadoopServiceException {
        switch (HadoopJobType.AdminJobType.valueOf((String)jobName)) {
            case copytable: {
                return this.copyTable(jobProfile, bbJob.getParameters(), jobConf);
            }
        }
        throw new HadoopServiceException("unknown admin job: " + jobName);
    }

    private JobConf copyTable(JobProfile jobProfile, Map<String, String> parameters, JobConf jobConf) throws IOException, HadoopServiceException {
        ScanProperties scan = jobProfile.getScanProperties();
        ArrayList params = Lists.newArrayList();
        if (!scan.getFamilies().isEmpty()) {
            String families = "--families=" + Joiner.on((String)",").join(scan.getFamilies());
            log.debug((Object)("adding column families: " + families));
            params.add(families);
        }
        if (parameters.containsKey("peer.adr") && !StringUtils.equals((CharSequence)parameters.get("sourceCluster"), (CharSequence)parameters.get("cluster"))) {
            String peerAdr = "--peer.adr=" + parameters.get("peer.adr");
            log.debug((Object)("adding peer address: " + peerAdr));
            params.add(peerAdr);
        }
        String targetTable = "--new.name=" + parameters.get("new.name");
        log.debug((Object)("adding target table: " + targetTable));
        params.add(targetTable);
        String sourceTable = parameters.get("hbase.mapreduce.inputtable");
        log.debug((Object)("adding source table: " + sourceTable));
        params.add(sourceTable);
        log.info((Object)("copy table params: " + params));
        Job copyJob = CopyTable.createSubmittableJob((Configuration)jobConf, (String[])((String[])Iterables.toArray((Iterable)params, String.class)));
        if (copyJob == null) {
            throw new HadoopServiceException("invalid copytable parameters: " + params);
        }
        Configuration copyConf = copyJob.getConfiguration();
        return this.merge(jobConf, copyConf);
    }

    private JobConf merge(JobConf jobConf, Configuration copyConf) {
        for (Map.Entry e : copyConf) {
            jobConf.set((String)e.getKey(), (String)e.getValue());
        }
        return jobConf;
    }
}

